<div class="row-fluid">
    <div class="span12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            <h3><?php echo __('User Management'); ?></h3>
        </h3>

    </div>
</div>

<div class="widget green">
    <div class="widget-title">
        <h4><i class="icon-reorder"></i>Users</h4>
        <span class="tools">
        <?php
            if($this->acl->check($user, 'controllers/'.strtolower($con).'/add')) {
                echo '<a href="'.$this->webroot.'Users/add">Add</a>';
            }
            $can_edit = $this->acl->check($user, 'controllers/'.strtolower($con).'/edit');
            $can_view = $this->acl->check($user, 'controllers/'.strtolower($con).'/view');
            $can_delete = $this->acl->check($user, 'controllers/'.strtolower($con).'/delete');
            if($can_delete) {
                echo '<a href="javascript:void(0)"  onclick="javascript:submitForm()">Delete</a>';
            }
        ?>
        </span>
    </div>
<?php if($can_delete) : ?>
    <form id="frm_delete_all" method="post" action="<?php echo $this->webroot; ?>users/delete">
<?php endif; ?>
        <div class="widget-body">
            <table class="table table-striped table-bordered" id="sample_1">
                <thead>
                    <tr>
                    <?php if($can_delete) : ?>
                        <th style="width:8px;"><input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes" /></th>
                    <?php endif; ?>
                        <th>Name</th>
                        <th>Group</th>
                        <th>Email</th>
                        <th>Mobile Number</th>
                        <th>User Name</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                <?php $i=0; foreach ($users as $u): ?>

                    <tr class="odd gradeX">
                    <?php if($can_delete) : ?>
                        <td><input type="checkbox" multiple="multiple" class="checkboxes" name="delete_all[]" id="delete_all" value="<?php echo $u['User']['id']; ?>"  /></td>
                    <?php
                        endif; 
                        if($can_edit) :
                    ?>
                        <td><?php echo $this->Html->link($u['User']['name'],array("action"=>"edit",$u['User']['id'])); ?></td>
                    <?php elseif($can_view) : ?>
                        <td><?php echo $this->Html->link($u['User']['name'],array("action"=>"view",$u['User']['id'])); ?></td>
                    <?php else : ?>
                        <td><?php echo $u['User']['name']; ?></td>
                    <?php endif; ?>
                        <td><?php echo $u['Group']['role']; ?></td>
                        <td><?php echo $u['User']['email']; ?></td>
                        <td><?php echo $u['User']['mobile_no']; ?></td>
                        <td><?php echo $u['User']['username']; ?></td>
                        <td class="hidden-phone">
                        <?php
                            if($u['User']['status']==1){
                                $class = "label label-success";
                            }else{
                               $class = "label label-important"; 
                            }
                            if($can_edit) :
                        ?>
                            <span class="<?php echo $class; ?>"><a href="javascript:void(0)" style="color: #fff; text-decoration: none" onclick="javascript:changeStatus('<?php echo $u['User']['status']; ?>', '<?php echo $u['User']['id']; ?>')"><?php echo ($u['User']['status']==1)?'Active':'Inactive'; ?></a></span>
                        <?php else : ?>
                            <span class="<?php echo $class; ?>"><?php echo ($u['User']['status']==1)?'Active':'Inactive'; ?></span>
                        <?php endif; ?>
                        </td>
                    </tr>

                <?php $i++; endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php if($can_delete) : ?> </form> <?php endif; ?>
</div>

<script>
<?php if($can_delete) : ?>
    function submitForm() {
        var n = $("input:checkbox:checked").length;
        if (n == 0) {
            alert("Please Select at least one record");
            return false;
        } else {
            if (confirm("Are You Sure?") == true) {
                document.getElementById("frm_delete_all").submit();
            }
        }

    }
<?php endif; ?>
<?php if($can_edit) : ?>
    function changeStatus(status, id) {
        $.ajax({
            url: "<?php echo $this->webroot; ?>users/UserStatus",
            type: 'GET',
            data: {
                status: status,
                id: id
            },
            success: function(data) {
                window.location = "<?php echo $this->webroot;  ?>users/index";
            },
        });
    }
<?php endif; ?>
</script>