<div class="row-fluid">
    <div class="span12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            <h3><?php echo __('Commission'); ?></h3>
        </h3>

    </div>
</div>

<div class="widget green">
    <div class="widget-title">
        <h4><i class="icon-reorder"></i>Not Paid Commission</h4>
    </div>

    <div class="widget-body">
        <?php if(!empty($not_paid)) {  ?>
            <table class="table table-striped table-bordered" id="sales_entry_tbl">
                <thead>
                    <tr>
                        <th>Client No.</th>
                        <th>Customer Name</th>
                        <th>Product Name</th>
                        <th>Agent Name</th>
                        <th>TL Name</th>
                        <th>Sales Date</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach($not_paid as $sale) :
                    $db_added_date = $sale['SalesEntry']['added_date'];
                    if($db_added_date != '0000-00-00') {
                        $db_added_date = new DateTime($db_added_date);
                        $db_added_date = $db_added_date->format('d-m-Y');
                    } else {
                        $db_added_date = '';
                    }
                ?>

                    <tr class="odd gradeX">
                        <td><?php echo $sale['SalesEntry']['client_no']; ?></td>
                        <td><?php echo $sale['Customer']['name']; ?></td>
                        <td><?php echo $sale['Product']['name']; ?></td>
                        <td><?php echo $sale['User']['name']; ?></td>
                        <td><?php echo $sale['TL']['name']; ?></td>
                        <td><?php echo $db_added_date; ?></td>
                        <td><span class="mc" data-key="<?php echo $sale['SalesEntry']['id'] ?>" data-value="1">PAY</span></td>
                    </tr>

                <?php endforeach; ?>
                </tbody>
            </table>
            <div class="row-fluid" style="margin-top:20px;">
                <div class="span6 offset6">
                    <div class="dataTables_paginate paging_bootstrap pagination">
                        <ul>                            
                        <?php
                            echo $this->Paginator->numbers(array(
                                'modulus'       => 4,
                                'first'         => '< First',
                                'last'          => 'Last >',
                                'before'        => '',
                                'after'         => '',
                                'separator'     => '',
                                'tag'           => 'li',
                                'currentClass' => 'active',
                                'currentTag'    => 'a'
                              )
                            );
                        ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>
<style>
span.mc {
    background-color: #74B749;
    color: #fff;
    cursor: pointer;
    padding: 5px 10px;
}
span.mc.inactive {
    background-color: #666 !important;
    cursor: wait;
}
span.mc.undo {
    background-color: #E2852B;
}
</style>
<script>
$(document).ready(function() {
var actv_commission = false;
    $('span.mc').click(function() {
        if(!actv_commission) {
            mc = $(this);
            actv_commission = true;
            mc.text('WAIT').addClass('inactive');
            key = mc.attr('data-key');
            value = parseInt(mc.attr('data-value'));
            $.ajax({
                async: true,
                url: "<?php echo $this->Html->url(array('controller' => 'SalesEntry', 'action' => 'change_commission', 'admin' => false)); ?>",
                type: "POST",
                data: {'key': key, 'value': value},
                success: function (data) {
                    if(data) {
                        if(value) {
                            mc.text('UNDO').addClass('undo').attr('data-value', 0);
                        } else {
                            mc.text('PAY').removeClass('undo').attr('data-value', 1);
                        }
                    } else {
                        alert('Something went wrong, please try again latter.');
                    }
                    actv_commission = false;
                    mc.removeClass('inactive');
                }
            });
        }
    });
});
</script>

<?php /*
Controller
    function commission() {
        $conditions['OR'] = array('SalesEntry.commission_status' => 0);
        $this->request->params['named']['keyword'] = 0;

        $this->Paginator->settings = array(
            'recursive' => 0,
            'limit' => 30,
            'conditions' => $conditions,
            'order' => array(
                'SalesEntry.client_no' => 'ASC'
            )
        );
        $not_paid = $this->Paginator->paginate('SalesEntry');
        $this->set('not_paid', $not_paid);
    }


    function change_commission() {
        if($this->request->is('post')) {
            $this->render = false;
            $this->layout = 'ajax';

            $key = $this->request->data['key'];
            $value = $this->request->data['value'];

            if($this->SalesEntry->save(array('id' => $key, 'commission_status' => $value))) {
                echo true;
            } else {
                echo false;
            }
            exit;
        }
    }*/
?>