<div class="row-fluid">
    <div class="span12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            <h3><?php echo __('Products Management'); ?></h3>
        </h3>

    </div>
</div>

<div class="widget green">
    <div class="widget-title">
        <h4><i class="icon-reorder"></i>Products</h4>
        <span class="tools">
        <?php
            if($this->acl->check($user, 'controllers/'.strtolower($con).'/add')) {
                echo '<a href="'.$this->webroot.'Products/add">Add</a>';
            }
            $can_edit = $this->acl->check($user, 'controllers/'.strtolower($con).'/edit');
            $can_view = $this->acl->check($user, 'controllers/'.strtolower($con).'/view');
            $can_delete = $this->acl->check($user, 'controllers/'.strtolower($con).'/delete');
            if($can_delete) {
                echo '<a href="javascript:void(0)"  onclick="javascript:submitForm()">Delete</a>';
            }
        ?>
        </span>
    </div>
<?php if($can_delete) : ?>
    <form id="frm_delete_all" method="post" action="<?php echo $this->webroot; ?>products/delete">
<?php endif; ?>
        <div class="widget-body">
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                    <?php if($can_delete) : ?>
                        <th style="width:8px;"><input type="checkbox" class="group-checkable" data-set="#sample_1 .checkboxes" /></th>
                    <?php endif; ?>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Category</th>
                        <th>Size</th>
                        <th>Color</th>
                        <th>Price</th>
                        <th>Commision</th>
                        <th>Team Leader Commision</th>
                        <th>Created</th>
                        <th>Modified</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                <?php $i=0; foreach ($products as $product): ?>

                    <tr class="odd gradeX">
                    <?php if($can_delete) : ?>
                        <td><input type="checkbox" multiple="multiple" class="checkboxes" name="delete_all[]" id="delete_all" value="<?php echo $product['Product']['id']; ?>"  /></td>
                    <?php
                        endif;
                        if($can_edit) :
                    ?>
                        <td><?php echo $this->Html->link($product['Product']['name'],array("action"=>"edit",$product['Product']['id'])); ?></td>
                    <?php elseif($can_view) : ?>
                        <td><?php echo $this->Html->link($product['Product']['name'],array("action"=>"view",$product['Product']['id'])); ?></td>
                    <?php else : ?>
                        <td><?php echo $product['Product']['name']; ?></td>
                    <?php endif; ?>
                        <td><?php echo empty($product['Product']['description'])?'---------------':$product['Product']['description']; ?></td>
                        <td><?php echo $product['Category']['title']; ?></td>
                        <td><?php echo $product['Product']['size']; ?></td>
                        <td><?php echo $product['Product']['color']; ?></td>
                        <td><?php echo $product['Product']['price']; ?></td>
                        <td><?php echo $product['Product']['commision']; ?></td>
                        <td><?php echo $product['Product']['tlc']; ?></td>
                        <td><?php echo $product['Product']['created']; ?></td>
                        <td><?php echo $product['Product']['modified']; ?></td>
                        <td class="hidden-phone">
                        <?php
                            if($product['Product']['status']==1){
                                $class = "label label-success";
                            }else{
                               $class = "label label-important"; 
                            }
                            if($can_edit) :
                        ?>
                            <span class="<?php echo $class; ?>"><a href="javascript:void(0)" style="color: #fff; text-decoration: none" onclick="javascript:changeStatus('<?php echo $product['Product']['status']; ?>', '<?php echo $product['Product']['id']; ?>')"><?php echo ($product['Product']['status']==1)?'Active':'Inactive'; ?></a></span>
                        <?php else : ?>
                            <span class="<?php echo $class; ?>"><?php echo ($product['Product']['status']==1)?'Active':'Inactive'; ?></span>
                        <?php endif; ?>
                        </td>
                    </tr>

                <?php $i++; endforeach; ?>
                </tbody>
            </table>
            <div class="row-fluid" style="margin-top:20px;">
                <div class="span6 offset6">
                    <div class="dataTables_paginate paging_bootstrap pagination">
                        <ul>                            
                        <?php
                            echo $this->Paginator->numbers(array(
                                'modulus'       => 4,
                                'first'         => '< First',
                                'last'          => 'Last >',
                                'before'        => '',
                                'after'         => '',
                                'separator'     => '',
                                'tag'           => 'li',
                                'currentClass' => 'active',
                                'currentTag'    => 'a'
                              )
                            );
                        ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    <?php if($can_delete) : ?> </form> <?php endif; ?>
</div>

<script>
<?php if($can_delete) : ?>
    function submitForm() {
        var n = $("input:checkbox:checked").length;
        if (n == 0) {
            alert("Please Select at least one record");
            return false;
        } else {
            if (confirm("Are You Sure?") == true) {
                document.getElementById("frm_delete_all").submit();
            }
        }

    }
<?php endif; ?>
<?php if($can_edit) : ?>
    function changeStatus(status, id) {
        $.ajax({
            url: "<?php echo $this->webroot; ?>products/productStatus",
            type: 'GET',
            data: {
                status: status,
                id: id
            },
            success: function(data) {
                window.location = "<?php echo $this->webroot;  ?>Products";
            },
        });
    }
<?php endif; ?>
</script>