<?php
/**
 * ACL level View Helper
 *
 * This file is application-wide helper file. You can put all
 * application-wide helper-related methods here.
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.View.Helper
 * @since         CakePHP(tm) v 0.2.9
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */

App::uses('Helper', 'View');
App::uses('AclComponent', 'Controller/Component');

/**
 * ACL helper
 *
 * Add your application-wide methods in the class below, your helpers
 * will inherit them.
 *
 * @package       app.View.Helper
 */
class aclHelper extends AppHelper {

	public function get_permissions($user) {

		$collection = new ComponentCollection();
	    $acl = new AclComponent($collection);		
		
		$acl->Aro->recursive = 1;
		$groupAro = $acl->Aro->find('threaded', array('conditions'=>array('model' => 'Group', 'foreign_key' => $user['group_id'])));
		$userAro = $acl->Aro->find('threaded', array('conditions'=>array('model' => 'User', 'foreign_key' => $user['id'])));

		$permissions['group'] = $this->get_actions($acl, $groupAro[0]);
		$permissions['user'] = $this->get_actions($acl, $userAro[0]);

		return $permissions;
	}

	public function get_actions($acl, $aro) {
		$p = array();
		foreach($aro['Aco'] as $action) {
			if(empty($action['parent_id'])) {
				$p[$action['alias']] = $action['Permission']['_create'];
			} elseif($action['parent_id'] == 1) {				
				$methods = $acl->Aco->find('all', array('conditions' => array('parent_id' => $action['id'])));
				
				foreach($methods as $m) {
					$p[$action['alias']][$m['Aco']['alias']] = $action['Permission']['_create'];
				}
			} elseif($action['parent_id'] != 1) {
				$alias = $acl->Aco->find('first', array('conditions' => array('id' => $action['parent_id'])));
				$alias = $alias['Aco']['alias'];
				$p[$alias][$action['alias']] = $action['Permission']['_create'];
			}		
		}
		return $p;
	}

	public function check($user, $aco_alias) {
		$collection = new ComponentCollection();
	    $acl = new AclComponent($collection);
	    $authFlag = false;

	    $db['aro'] = $acl->Aro->node(array('User' => array('id' => $user['id']))); 
        $db['aco'] = $acl->Aco->node($aco_alias);

        $db['con'] = ConnectionManager::getDataSource('default');
        $aa_node = $db['con']->fetchAll("SELECT *
        FROM `aros_acos` AS `AA`
        WHERE `AA`.`aro_id` = {$db['aro'][0]['Aro']['id']} AND `AA`.`aco_id` = {$db['aco'][0]['Aco']['id']}");

        $user_in_db = ($aa_node) ? true : false; 

        if($user_in_db && $authFlag == false && !empty($user)) {
            $authFlag = $acl->check(array('User' => array('id' => $user['id'])), $aco_alias);
        }

        if(!$user_in_db && $authFlag == false && !empty($user)) {
            $authFlag = $acl->check(array('Group' => array('id' => $user['group_id'])), $aco_alias);
        }

        return $authFlag;
    }
}