<!-- BEGIN SIDEBAR -->
<?php

$permissions = $this->acl->get_permissions($user);

function check_permission($permissions, $level, $key, $action = 'index') {
    $flag = false;
    if(!empty($permissions['user']) && ( array_key_exists('controllers', $permissions['user']) && $permissions['user']['controllers'] == 1 )) {
        $flag = true;
    } elseif($permissions['group']['controllers'] == 1) {
        $flag = true;
    } else {
        if($level == 'parent') {
            if(array_key_exists($key, $permissions['user'])) {
                $flag = 'user';
            } elseif(array_key_exists($key, $permissions['group'])) {
                $flag = 'group';
            }
        } elseif($level == 'child') {
            $group = check_permission($permissions, 'parent', $key);
            if($group) {
                if(is_array($permissions[$group][$key])) {
                    if( array_key_exists($action, $permissions[$group][$key]) && $permissions[$group][$key][$action] == 1) {
                        $flag = true;
                    }
                } else {
                    if($permissions[$group][$key] == 1) {
                        $flag = true;
                    }
                }
            }
        }
    }   
    return $flag;
}
?>
<div class="sidebar-scroll">
    <div id="sidebar" class="nav-collapse collapse">

        <!-- BEGIN RESPONSIVE QUICK SEARCH FORM -->
        <div class="navbar-inverse">
            <form class="navbar-search visible-phone">
                <input type="text" class="search-query" placeholder="Search"/>
            </form>
        </div>
        <!-- END RESPONSIVE QUICK SEARCH FORM -->
        <!-- BEGIN SIDEBAR MENU -->
        <ul class="sidebar-menu">
        <?php
            $p_flag = check_permission($permissions, 'parent', 'users');
            if(!$p_flag) { $p_flag = check_permission($permissions, 'parent', 'groups'); }

            if($p_flag) :
        ?>
            <li <?php
                    if ($con == 'users' || $con == 'Users' || $con == 'Groups') {
                        $class = 'active';
                    } else {
                        $class = '';
                    }
                    ?>  class="sub-menu <?php echo $class; ?>">
                <a href="javascript:;" class="">
                    <i class="icon-user"></i>
                    <span>User</span>
                    <span class="arrow"></span>
                </a>
                <ul class="sub">
                <?php
                    if(check_permission($permissions, 'child', 'groups')) {
                        echo '<li><a class="" href="'.$this->webroot.'Groups">Groups</a></li>';
                    }
                    if(check_permission($permissions, 'child', 'users')) {
                        echo '<li><a class="" href="'.$this->webroot.'Users">Users</a></li>';
                    }
                ?>
                </ul>
            </li>
        <?php
            endif;

            if(check_permission($permissions, 'parent', 'customers')) :
        ?>
            <li <?php
                    if($con == 'Customers' && $action != 'import_csv') {
                        $class = 'active';
                    } else {
                        $class = '';
                    }
                    ?>  class="sub-menu <?php echo $class; ?>">
                <a href="javascript:;" class="">
                    <i class="icon-tasks"></i>
                    <span>Customer</span>
                    <span class="arrow"></span>
                </a>
                <ul class="sub">
                <?php
                    if(check_permission($permissions, 'child', 'customers')) {
                        echo '<li><a class="" href="'.$this->webroot.'Customers">All Customers</a></li>';
                    }
                    if(check_permission($permissions, 'child', 'customers', 'add')) {
                        echo '<li><a class="" href="'.$this->webroot.'Customers/add">Add New Customer</a></li>';
                    }
                ?>
                </ul>
            </li>
        <?php
            endif;

            $p_flag = check_permission($permissions, 'parent', 'categories');
            if(!$p_flag) { $p_flag = check_permission($permissions, 'parent', 'products'); }

            if($p_flag) :
        ?>
            <li
                <?php
                    if($con == 'Products' || $con == 'Categories') {
                        $class = 'active';
                    } else {
                        $class = '';
                    }
                ?>  class="sub-menu <?php echo $class; ?>">
                <a href="javascript:;" class="">
                    <i class="icon-shopping-cart"></i>
                    <span>Product</span>
                    <span class="arrow"></span>
                </a>
                <ul class="sub">
                <?php
                    if(check_permission($permissions, 'child', 'categories')) {
                        echo '<li><a class="" href="'.$this->webroot.'Categories">Categories</a></li>';
                    }
                    if(check_permission($permissions, 'child', 'products')) {
                        echo '<li><a class="" href="'.$this->webroot.'Products">Products</a></li>';
                    }
                ?>
                </ul>
            </li>
        <?php
            endif;

            if(check_permission($permissions, 'parent', 'salesentry')) :
        ?>
            <li
                <?php
                    if ($con == 'SalesEntry' && !in_array($action, array('payrun', 'missing_payments', 'commission', 'generated_invoice', 'reports'))) {
                        $class = 'active';
                    } else {
                        $class = '';
                    }
                ?>  class="sub-menu <?php echo $class; ?>">
                <a href="javascript:;" class="">
                    <i class="icon-book"></i>
                    <span>Sales Entry</span>
                    <span class="arrow"></span>
                </a>
                <ul class="sub">
                <?php
                    if(check_permission($permissions, 'child', 'salesentry')) {
                        echo '<li><a class="" href="'.$this->webroot.'SalesEntry">All Sales Entries</a></li>';
                    }
                    if(check_permission($permissions, 'child', 'salesentry', 'add')) {
                        echo '<li><a class="" href="'.$this->webroot.'SalesEntry/add">Add New Sales Entry</a></li>';
                    }
                ?>
                </ul>
            </li>
        <?php
            endif;

            if(check_permission($permissions, 'child', 'customernotes')) :
        ?>
            <li
                <?php
                    if ($con == 'CustomerNotes') {
                        $class = 'active';
                    } else {
                        $class = '';
                    }
                ?>  class="sub-menu <?php echo $class; ?>">
               <a class="" href="<?php echo $this->webroot; ?>CustomerNotes">
                    <i class="icon-file-alt"></i>
                    <span>Customer Notes</span>
                </a>
            </li>
        <?php
            endif;

            if(check_permission($permissions, 'child', 'controllers')) :
        ?>
            <li
                <?php
                    if((in_array($con, array('Customers', 'SalesEntry')) && in_array($action, array('import_csv', 'payrun', 'missing_payments', 'commission', 'generated_invoice', 'reports', 'user', 'groups'))) || ($con == 'useraccess' && $action == 'index')) {
                        $class = 'active';
                    } else {
                        $class = '';
                    }
                ?>  class="sub-menu <?php echo $class; ?>">
                <a href="javascript:;" class="">
                    <i class="icon-cogs"></i>
                    <span>Admin Tools</span>
                    <span class="arrow"></span>
                </a>
                <ul class="sub">
                    <li><a href="<?php echo $this->webroot; ?>Customers/import_csv">Upload CSV</a></li>
                    <li><a href="<?php echo $this->webroot; ?>SalesEntry/missing_payments">Missing Payments</a></li>
                    <li><a href="<?php echo $this->webroot; ?>SalesEntry/payrun">Pay Run</a></li>
                    <li><a href="<?php echo $this->webroot; ?>SalesEntry/commission">Commission</a></li>
                    <li><a href="<?php echo $this->webroot; ?>SalesEntry/generated_invoice">Generated Invoice</a></li>
                    <li><a href="<?php echo $this->webroot; ?>SalesEntry/reports">Reports</a></li>
                    <li><a href="<?php echo $this->webroot; ?>useraccess">User Access</a></li>
                </ul>
            </li>
        <?php endif; ?>
        </ul>
        <!-- END SIDEBAR MENU -->
    </div>
    <div id="site_copyright">
       <?php echo  'Copyrignt &copy; '.date("Y").' '; ?> Sales Concepts Pvt. All right reserved.   
   </div>
</div>
<!-- END SIDEBAR -->