<script>
    function check_search() {
        var name_code_val = $("#search_code").val();
        // var status=$("#sts").val();
        if (name_code_val == "") {
            alert("Please enter your search criteria to perform search.");
            return false;
        }
    }
</script>
<div class="row-fluid">
    <div class="span12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            <h3><?php echo __('Customer Management'); ?></h3>
        </h3>

    </div>
</div>

<div class="widget green">
    <div class="widget-title">
        <h4><i class="icon-reorder"></i>Customers</h4>
        <span class="tools">
        <?php
            if($this->acl->check($user, 'controllers/'.strtolower($con).'/add')) {
                echo '<a href="'.$this->webroot.'Customers/add">Add</a>';
            }
            $can_edit = $this->acl->check($user, 'controllers/'.strtolower($con).'/edit');
            $can_view = $this->acl->check($user, 'controllers/'.strtolower($con).'/view');
            $can_delete = $this->acl->check($user, 'controllers/'.strtolower($con).'/delete');
            if(!empty($customers) && $can_delete) {
                echo '<a href="javascript:void(0)"  onclick="javascript:submitForm()">Delete</a>';
            }
        ?>
        </span>
    </div>

    <div class="widget-body big_search">
        <?php echo $this->Form->create('Customers', array('url' => array('controller' => 'Customers', 'action' => 'index'))); ?>
        <?php echo $this->Form->input('keyword', array('placeholder' => 'client_no / customer_name / mobile_no / dob', 'type' => 'text', 'id' => 'search_code', 'label' => false, "div" => false, 'required' => false, 'class' => 'search_required', 'maxlength' => 200)); ?>
        <?php echo $this->Form->submit('Search', array("div" => false, 'onclick' => 'return check_search();')); ?>
        <button><a href="">Reset</a></button>
        <?php echo $this->Form->end(); 

        if (!empty($customers)) {
if($can_delete) : ?>
    <form id="frm_delete_all" method="post" action="<?php echo $this->webroot; ?>customers/delete">
<?php endif; ?>
            <table class="table table-striped table-bordered" id="customers_tbl">
                <thead>
                    <tr>
                    <?php if($can_delete) : ?>
                        <th style="width:8px;"><input type="checkbox" class="group-checkable" data-set="#customers_tbl .checkboxes" /></th>
                    <?php endif; ?>
                        <th>Client No</th>
                        <th>Name</th>
                        <th>Birthdate</th>
                        <th>Email</th>
                        <th>Mobile No.</th>
                        <th>Phone No.</th>
                        <th>Address</th>
                        <th>ID Proof</th>
                        <th>ID No.</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                <?php $i=0; foreach ($customers as $cus): //var_dump($cus);
                    $dob = $cus['Customer']['dob'];
                    if($dob != '0000-00-00') {
                        $dob = new DateTime($dob);
                        $dob = $dob->format('d-m-Y');
                    } else {
                        $dob = '';
                    }
                ?>

                    <tr class="odd gradeX">
                    <?php if($can_delete) : ?>
                        <td><input type="checkbox" multiple="multiple" class="checkboxes" name="delete_all[]" id="delete_all" value="<?php echo $cus['Customer']['id']; ?>"  /></td>
                    <?php
                        endif;
                        if($can_edit) :
                    ?>
                        <td><?php echo $this->Html->link($cus['SalesEntry']['client_no'],array("action"=>"edit",$cus['Customer']['id'])); ?></td>
                    <?php elseif($can_view) : ?>
                        <td><?php echo $this->Html->link($cus['SalesEntry']['client_no'],array("action"=>"view",$cus['Customer']['id'])); ?></td>
                    <?php else : ?>
                        <td><?php echo $cus['SalesEntry']['client_no']; ?></td>
                    <?php endif; ?>
                        <td><?php echo $cus['Customer']['name']; ?></td>
                        <td><?php echo $dob; ?></td>
                        <td><?php echo $cus['Customer']['email']; ?></td>
                        <td><?php echo $cus['Customer']['mobile']; ?></td>
                        <td><?php echo $cus['Customer']['phone']; ?></td>
                        <td><?php echo '<strong>Street No.</strong>: '.$cus['Customer']['street_no'];
                        echo '<br /><strong>Street Name</strong>: '.$cus['Customer']['street_name'];
                        echo '<br /><strong>Suburb</strong>: '.$cus['Customer']['suburb'];
                        echo '<br /><strong>Postcode</strong>: '.$cus['Customer']['postcode'];
                        echo '<br /><strong>City</strong>: '.$cus['Customer']['city']; ?></td>
                        <td><?php echo $cus['Customer']['id_proof']; ?></td>
                        <td><?php echo $cus['Customer']['id_no']; ?></td>
                        <td class="hidden-phone">
                        <?php
                            if($cus['Customer']['status']==1){
                                $class = "label label-success";
                            }else{
                               $class = "label label-important"; 
                            }
                            if($can_edit) :
                        ?>
                            <span class="<?php echo $class; ?>"><a href="javascript:void(0)" style="color: #fff; text-decoration: none" onclick="javascript:changeStatus('<?php echo $cus['Customer']['status']; ?>', '<?php echo $cus['Customer']['id']; ?>')"><?php echo ($cus['Customer']['status']==1)?'ACTIVE':'CANCELLED'; ?></a></span>
                        <?php else : ?>
                            <span class="<?php echo $class; ?>"><?php echo ($cus['Customer']['status']==1)?'ACTIVE':'CANCELLED'; ?></span>
                        <?php endif; ?>
                            </td>
                    </tr>

                <?php $i++; endforeach; ?>
                </tbody>
            </table>
            <div class="row-fluid" style="margin-top:20px;">
                <div class="span6 offset6">
                    <div class="dataTables_paginate paging_bootstrap pagination">
                        <ul>                            
                        <?php
                            echo $this->Paginator->numbers(array(
                                'modulus'       => 4,
                                'first'         => '< First',
                                'last'          => 'Last >',
                                'before'        => '',
                                'after'         => '',
                                'separator'     => '',
                                'tag'           => 'li',
                                'currentClass' => 'active',
                                'currentTag'    => 'a'
                              )
                            );
                        ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php if($can_delete) : ?> </form> <?php endif; ?>
        <?php } ?>
    </div>
</div>

<script>
<?php if($can_delete) : ?>
    function submitForm() {
        var n = $("input:checkbox:checked").length;
        if (n == 0) {
            alert("Please Select at least one record");
            return false;
        } else {
            if (confirm("Are You Sure?") == true) {
                document.getElementById("frm_delete_all").submit();
            }
        }

    }
<?php endif; ?>
<?php if($can_edit) : ?>
    function changeStatus(status, id) {
        $.ajax({
            url: "<?php echo $this->webroot; ?>customers/customerStatus",
            type: 'GET',
            data: {
                status: status,
                id: id
            },
            success: function(data) {
                window.location = "<?php echo $this->webroot;  ?>Customers";
            },
        });
    }
<?php endif; ?>
</script>