<?php
App::uses('AppModel', 'Model');
/**
 * User Model
 *
 * @property Profile $Profile
 * @property Group $Group
 */
class User extends AppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';


	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * hasMany associations
 *
 * @var array
 */        
    public $hasMany = array(
        'CustomerNotes' => array(
			'className' 	=> 'CustomerNotes',
			'foreignKey'	=> 'user_id'
		),
        'SalesEntry'=>array(
            'className' 	=> 'SalesEntry',
			'foreignKey' 	=> 'user_id'
	    )
    );

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'Group' => array(
			'className' 	=> 'Group',
			'foreignKey' 	=> 'group_id'
		)
	);

	public $actsAs = array('Acl' => array('requester'));
 
	function parentNode() {
	    if(!$this->id && empty($this->data)) {
	        return null;
	    }
	    $data = $this->data;
	    if(empty($this->data)) {
	        $data = $this->read();
	    }
	    if(!array_key_exists('group_id', $data['User'])) {
	        return null;
	    } else {
	        return array('Group' => array('id' => $data['User']['group_id']));
	    }
	}
}
?>