<?php

App::uses('AppController', 'Controller');
App::uses('CakeEmail', 'Network/Email');

/**
 * Users Controller
 *
 * @property User $User
 * @property PaginatorComponent $Paginator
 * @property SessionComponent $Session
 */
class UsersController extends AppController {

    /**
     * Site Layout
     *
     * @return void
     */
    public $layout = 'admin_home';
    public $components = array('Auth', 'Acl');
  
    public function beforeFilter() {
        parent::beforeFilter();
        if(isset($this->viewVars['user']) && $this->viewVars['user']['Group']['role'] != 'Admin' && isset($this->params['pass'][0])) {
        if($this->viewVars['user']['id'] != $this->params['pass'][0]) {
            $this->redirect(array('controller' => 'useraccess', 'action' => 'no_access'));
        }}
        //$this->Auth->allow();
        $this->Auth->allow('login', 'logout', 'forgetPassword', 'resetPassword', 'changePassword', 'view', 'edit', 'UserStatus');
    }

    /**
     * index method
     *
     * @return void
     */

    public function index() {

        /*if($this->Session->read('userData.Group.role') == 'Admin'){
            $this->Session->setFlash('Access Granted !!', 'admin_msg_good');
           // return true;
        }
        else{
            $this->Session->setFlash('You Do not haing Permission to access this contents..', 'admin_msg_bad');
            $this->redirect(array('action'=>'dashboard'));
            return;
        }*/

        $this->Paginator->settings = array(
            'recursive' => 1,
            'limit' => 30,
            'order' => array(
                'User.name' => 'ASC'
            )
        );
        
        $users = $this->Paginator->paginate('User');
        $this->set('users', $users);
    }

    /**
     * view method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function view($id = null) {
        if (!$this->User->exists($id)) {
            throw new NotFoundException(__('Invalid user'));
        }
        $this->User->recursive = 0;
        $options = array('conditions' => array('User.id' => $id));
        $this->set('u', $this->User->find('first', $options));
    }

    /**
     * add method
     *
     * @return void
     */
    public function add() {

        if ($this->request->is('post')) {

            $currentDate = date('Y-m-d H:i:s');

            $this->request->data['User']['created'] = $currentDate;
            $this->request->data['User']['password'] = AuthComponent::password($this->request->data['User']['password']);
            $this->request->data['User']['uniqueKey'] = md5($currentDate);

            $this->User->create();
            if ($this->User->save($this->request->data)) {
                $this->Session->setFlash('The user has been created.', 'admin_msg_good');
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash('The user could not be created. Please, try again.', 'admin_msg_bad');
            }
        }
        $groups = $this->User->Group->find('list');
        $this->set(compact('groups'));
    }

    /**
     * edit method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function edit($id = null) {

        $data = $this->User->read(null, $id);

        if ($this->request->is(array('post', 'put'))) {

            $currentDate = date('Y-m-d H:i:s');

            $this->request->data['User']['modified'] = $currentDate;

            $data = array(
                'name' => $this->request->data['User']['name'],
                'group_id' => $this->request->data['User']['group_id'],
                'email' => $this->request->data['User']['email'],
                'phone_no' => $this->request->data['User']['phone_no'],
                'mobile_no' => $this->request->data['User']['mobile_no'],
                'username' => $this->request->data['User']['username'],
                'modified' => $this->request->data['User']['modified']
            );

            $this->User->id = $id;

            if ($this->User->save($data)) {
                $this->Session->setFlash('User saved Sucessfully', 'admin_msg_good');
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash(__('The user could not be saved. Please, try again.', 'admin_msg_bad'));
            }
        }

        if (!$this->request->data) {
            $this->data = $data;
        }

        $groups = $this->User->Group->find('list');
        $this->set(compact('groups'));
    }

    /**
     * delete method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function delete($id = null) {
        if (!empty($_POST)) {
            foreach ($_POST['delete_all'] as $key => $val) {
                $this->User->delete($val);
            }
            $this->Session->setFlash('User(s) Deleted Sucessfully', 'admin_msg_good');
            return $this->redirect(array('action' => 'index'));
        }
    }

    public function UserStatus() {
        $this->autoRender = FALSE;
        if($this->request->is('ajax')) {
            switch ($_GET['status']) {
                case 1:
                    $this->User->updateAll(array('User.status' => 0), array('User.id' => $_GET['id']));
                    break;
                case 0:
                    $this->User->updateAll(array('User.status' => 1), array('User.id' => $_GET['id']));
                    break;
            }
        }
    }

    public function login() {
        $this->layout = 'admin_login';
        $this->Auth->logout();
        $this->Session->delete('userData');
        if($this->request->is('post')) {
            if ($this->Auth->login()) {
                $u = $this->Auth->user();
                $this->Session->write('userData', $u);
                $this->Session->setFlash('You are logged in sucessfully', 'admin_msg_good');
                $this->redirect($this->Auth->redirectUrl().'/'.$u['id']);
            } else {
                $this->Session->setFlash('Invalid Username or Password', 'admin_msg_bad');
                return false;
            }
        }
    }

    public function forgetPassword() {
        $this->layout = 'admin_login';
        if (isset($_POST) && !empty($_POST['txtemail'])) {
            $data = $this->User->find('first', array(
                'conditions' => array('User.email' => $_POST['txtemail'])
            ));
            if ($data) {
                setcookie('user_id', $data['User']['id'], time()+(60*15));
                $Email = new CakeEmail();
                $Email->viewVars(array('uid' => $data['User']['uniqueKey']));
                $Email->template('forget_password', 'default')
                        ->emailFormat('html')
                        ->to($data['User']['email'])->from('admin@fionaadvert.com')->subject('Reset Password');
                if ($Email->send()) {
                    $this->Session->setFlash('Reset Link Send Sucessfully', 'admin_msg_good');
                } else {
                    $this->Session->setFlash('There is a Problem Plz try after sometimes', 'admin_msg_bad');
                }
            }else{
                $this->Session->setFlash('Wrong Email Address', 'admin_msg_bad');
                return false;
            }
        }
    }
    
    public function resetPassword(){
        $this->layout = 'admin_login';
        $u_id = $_COOKIE['user_id'];
        if(!empty($u_id)){
            if(!empty($_POST)){
                $password = AuthComponent::password($_POST['txtPass']);
                $confirmPass = AuthComponent::password($_POST['txtcpass']);
                
                if($password!=$confirmPass){
                   $this->Session->setFlash('Password and Confirm Password Does not matched','admin_msg_bad'); 
                }else{
                    unset($_COOKIE['user_id']);
                    $this->User->query("UPDATE users SET password = '{$password}' WHERE id = {$u_id}");
                    $this->Session->setFlash('Passwrod Changed Sucessfully','admin_msg_good');
                    return $this->redirect($this->Auth->redirectUrl());
                }
                
            }else{
                $this->Session->setFlash('Please Enter Valid Data.','admin_msg_bad');
            }
        }else{
            $this->Session->setFlash('Your link expeired','admin_msg_bad');
            return $this->redirect(array('action'=>'forgetPassword','controller'=>'users'));
        }
    }

    public function logout() {
        $this->layout = 'admin_login';

        if ($this->Session->check('userData')) {
            $this->Auth->logout();
            $this->Session->delete('userData');
            $this->Session->setFlash('You are logout Successfully', 'admin_msg_good');
            $this->redirect($this->Auth->redirectUrl());
        } else {
            $this->Session->setFlash('Direct Access Not Allowed', 'admin_msg_bad');
            $this->redirect($this->Auth->redirectUrl());
        }
    }
    
    public function changePassword(){
        $userData= $this->Session->read('userData');
        if($this->request->is('post')){
            $this->User->data['User']['password'] = AuthComponent::password($this->request->data['User']['password']);
            $this->User->id = $userData['id'];
            if($this->User->save($this->User->data)){
                $this->Session->setFlash('Password Changed Sucessfully', 'admin_msg_good');
                return $this->redirect($this->logout());
            }  else {
                $this->Session->setFlash('Password Change failed, try after some times', 'admin_msg_bad');
                return $this->redirect(array('action' => 'edit/'.$userData['id'], 'controller' => 'users'));
            }
        }
    }

}