<?php

class SalesEntryController extends AppController
{
    public $s_status = array(
        0 => 'CANCELLED',
        1 => 'ACTIVE',
        2 => 'ALTERED'
    );

    public $d_status = array(
        0 => 'NOT DELIVERED',
        1 => 'DELIVERED'
    );

    public $c_status = array(
        0 => 'NOT PAID',
        1 => 'PAID'
    );

    public $sign_form = array(
        0 => 'Blank',
        1 => 'Signed'
    );

    public $uses = array('Customer', 'Product', 'User', 'SalesEntry');

    public $layout = 'admin_home';
    
    public $components = array('Acl', 'PhpExcel.PhpExcel');

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('one_line_pay_detail', 'save_note', 'getClient', 'check_client_no', 'check_cus_name', 'get_product_detail', 'download_file', 'delete_file', 'uploadFiles', 'missing_payments', 'mp_change_client');
    }


    public function index()
    {

        //$this->SalesEntry->recursive = 1;

        //$this->set('sales', $this->SalesEntry->find('all'));
        //$this->set('sales', $this->paginate('SalesEntry'));
        $conditions = array();
        $sales_entry_data = array();
        $page = 1;
        if(isset($this->request->params['named']['keyword'])) {
            $keyword = $this->request->params['named']['keyword'];
        }
        if(isset($this->request->params['named']['page'])) {
            $page = $this->request->params['named']['page'];
        }

        if($this->request->is('post') || !empty($keyword)) {
            if(isset($this->request->data['SalesEntry']['keyword'])) {
                $keyword = addslashes(trim($this->request->data['SalesEntry']['keyword']));
            }

            $cond = array();
            $cond['SalesEntry.client_no LIKE'] = '%' . $keyword . '%';
            $cond['Customer.name LIKE'] = '%' . $keyword . '%';
            $cond['Customer.mobile LIKE'] = '%' . $keyword . '%';
            $cond['Customer.dob LIKE'] = '%' . $keyword . '%';
            $conditions['OR'] = $cond;
            $this->request->params['named']['keyword'] = $keyword;

            $this->Paginator->settings = array(
                'recursive' => 0,
                'limit' => 30,
                'page' => $page,
                'conditions' => $conditions,
                'order' => array(
                    'SalesEntry.client_no' => 'ASC'
                )
            );
            $sales_entry_data = $this->Paginator->paginate('SalesEntry');
        }
        $this->set('sales', $sales_entry_data);
    }

    public function add()
    {
        $sales_person = $this->User->find('list', array('conditions' => array('User.group_id' => 4, 'User.status' => 1)));
        $this->set('users', $sales_person);

        $tl_list = $this->User->find('list', array('conditions' => array('User.group_id' => 3, 'User.status' => 1)));
        $this->set('tl_list', $tl_list);

        $products = array();
        $all_products = $this->Product->find('all', array('fields' => array('id', 'name', 'color'), 'conditions' => array('Product.status' => 1)));
        foreach ($all_products as $key => $value) {
            $products[$value['Product']['id']] = $value['Product']['name'].' ('.$value['Product']['color'].')';
        }
        $this->set('product_list', $products);

        if ($this->request->is('post')) {
            $client_no = $this->request->data['SalesEntry']['client_no'];
            $result = $this->SalesEntry->findByClientNo($client_no);
            if(!empty($result)) {
                $this->Session->setFlash('Client Number already exist.', 'admin_msg_bad');
            }
            else {
                // upload the file to the server
                $forms = array('sales_form', 'ap_form', 'recurring_ap_form', 'cancellation_form', 'email_comm_form_1', 'email_comm_form_2');
                
                foreach ($forms as $form) {
                    if($this->request->data['SalesEntry'][$form]['error'] === 0) {

                        $fileOK = $this->uploadFiles('files/'.$form, $this->request->data['SalesEntry'][$form], $this->data['SalesEntry']['client_no']);
                
                        if(!array_key_exists('errors', $fileOK)) {
                            // if file was uploaded ok
                            if(array_key_exists('file', $fileOK)) {
                                // save the url in the form data
                                $this->request->data['SalesEntry'][$form] = $fileOK['file']['name'];
                                $this->request->data['SalesEntry'][$form.'_dir'] = $fileOK['file']['url'];
                            } elseif(!$fileOK['exists']) {
                                $this->request->data['SalesEntry'][$form] = 'No File';
                                $this->request->data['SalesEntry'][$form.'_dir'] = 'No File';                            
                            }
                        } else {
                            $errs = '<ul>';
                            foreach($fileOK['errors'] as $err) {
                                $errs .= '<li>'.$err.'</li>';
                            }
                            $errs .= '</ul>';
                            $this->Session->setFlash($errs, 'admin_msg_bad');
                        }
                    } else {
                        $this->request->data['SalesEntry'][$form] = 'No File';
                        $this->request->data['SalesEntry'][$form.'_dir'] = 'No File';                            
                    }
                }
                
                $this->request->data = $this->set_payment_mode($this->request->data);

                $date_time = date('Y-m-d H:i:s');

                $cust_id = '';
                if(!empty($this->request->data['SalesEntry']['cus_id'])) {
                    $cust_id = $this->request->data['SalesEntry']['cus_id'];
                }
                $all_good = false;
                if(empty($cust_id)) {
                    $new_cus = array();
                    $new_cus['id'] = '';
                    $new_cus['Customer']['name'] = $this->request->data['Customer']['name'];
                    $new_cus['Customer']['dob'] = $this->request->data['Customer']['dob'];
                    $new_cus['Customer']['street_no'] = $this->request->data['Customer']['street_no'];
                    $new_cus['Customer']['street_name'] = $this->request->data['Customer']['street_name'];
                    $new_cus['Customer']['suburb'] = $this->request->data['Customer']['suburb'];
                    $new_cus['Customer']['postcode'] = $this->request->data['Customer']['postcode'];
                    $new_cus['Customer']['city'] = $this->request->data['Customer']['city'];
                    $new_cus['Customer']['email'] = $this->request->data['Customer']['email'];
                    $new_cus['Customer']['mobile'] = $this->request->data['Customer']['mobile'];
                    $new_cus['Customer']['phone'] = $this->request->data['Customer']['phone'];
                    $new_cus['Customer']['id_proof'] = $this->request->data['Customer']['id_proof'];
                    $new_cus['Customer']['id_no'] = $this->request->data['Customer']['id_no'];

                    $new_cus['Customer']['created'] = $date_time;
                    $new_cus['Customer']['modified'] = $date_time;
                    $all_good = $this->Customer->save($new_cus);
                    $cust_id = $this->Customer->id;
                    $this->request->data['SalesEntry']['cus_id'] = $cust_id;
                } else {
                    $all_good = true;
                }

                if($all_good) {
                    $this->request->data['SalesEntry']['modified'] = $date_time;
                    if($this->SalesEntry->save($this->request->data)) {
                        $this->Session->setFlash('The sales entry has been saved.', 'admin_msg_good');
                        return $this->redirect(array('action' => 'index'));
                    } else {
                        $this->Session->setFlash('something went wrong, please try again letter.', 'admin_msg_bad');
                    }
                } else {
                    $this->Session->setFlash('something went wrong, please try again letter.', 'admin_msg_bad');
                }  
            }
        }
    }


    public function edit($id = null)
    {
        $sales_person = $this->User->find('list', array('conditions' => array('User.group_id' => 4, 'User.status' => 1)));
        $this->set('users', $sales_person);

        $all_products = $this->Product->find('all', array('fields' => array('id', 'name', 'color', 'status')));
        foreach ($all_products as $key => $value) {
            $products[$value['Product']['id']] = $value['Product']['name'].' ('.$value['Product']['color'].')';
            if(!$value['Product']['status']) {
                $products[$value['Product']['id']] .= ' - [inactive]';
            }
        }
        $this->set('product_list', $products);
        $data = $this->SalesEntry->read(null, $id);
        $s_status = $data['SalesEntry']['status'];
        $s_status = ($s_status == 2) ? 1 : $s_status;
        $edit = true;
        if ($this->request->is(array('post', 'put'))) {
            $this->SalesEntry->id = $id;

            // upload the file to the server
            $forms = array('sales_form', 'ap_form', 'recurring_ap_form', 'cancellation_form', 'email_comm_form_1', 'email_comm_form_2');
            foreach($forms as $form) {
                if(array_key_exists($form, $this->request->data['SalesEntry'])) {
                    if($this->request->data['SalesEntry'][$form]['error'] === 0) {
                        $fileOK = $this->uploadFiles('files/'.$form, $this->request->data['SalesEntry'][$form], $this->data['SalesEntry']['client_no']);
                
                        if(!array_key_exists('errors', $fileOK)) {
                            // if file was uploaded ok
                            if(array_key_exists('file', $fileOK)) {
                                // save the url in the form data
                                $this->request->data['SalesEntry'][$form] = $fileOK['file']['name'];
                                $this->request->data['SalesEntry'][$form.'_dir'] = $fileOK['file']['url'];
                            } elseif(!$fileOK['exists']) {
                                $this->request->data['SalesEntry'][$form] = 'No File';
                                $this->request->data['SalesEntry'][$form.'_dir'] = 'No File';                            
                            } elseif($fileOK['exists']) {
                                $this->request->data['SalesEntry'][$form] = $data['SalesEntry'][$form];
                                $this->request->data['SalesEntry'][$form.'_dir'] = $data['SalesEntry'][$form.'_dir'];
                            }
                        } else {
                            $edit = false;
                            $errs = '<ul>';
                            foreach($fileOK['errors'] as $err) {
                                $errs .= '<li>'.$err.'</li>';
                            }
                            $errs .= '</ul>';
                            $this->request->data['SalesEntry'][$form] = 'No File';
                            $this->request->data['SalesEntry'][$form.'_dir'] = 'No File';  
                            $this->Session->setFlash($errs, 'admin_msg_bad');
                        }
                    } elseif($this->request->data['SalesEntry'][$form]['error'] == 4) {
                        $this->request->data['SalesEntry'][$form] = 'No File';
                        $this->request->data['SalesEntry'][$form.'_dir'] = 'No File';
                    }
                } else {
                    $this->request->data['SalesEntry'][$form] = $data['SalesEntry'][$form];
                    $this->request->data['SalesEntry'][$form.'_dir'] = $data['SalesEntry'][$form.'_dir'];
                }
            }
            if($edit) {
                $this->request->data = $this->set_payment_mode($this->request->data);

                $date_time = date('Y-m-d H:i:s');

                $cust_id = '';
                if(!empty($this->request->data['SalesEntry']['cus_id'])) {
                    $cust_id = $this->request->data['SalesEntry']['cus_id'];
                }
                $all_good = false;
                if(empty($cust_id)) {
                    $new_cus = array();
                    $new_cus['id'] = '';
                    $new_cus['Customer']['name'] = $this->request->data['Customer']['name'];
                    $new_cus['Customer']['dob'] = $this->request->data['Customer']['dob'];
                    $new_cus['Customer']['street_no'] = $this->request->data['Customer']['street_no'];
                    $new_cus['Customer']['street_name'] = $this->request->data['Customer']['street_name'];
                    $new_cus['Customer']['suburb'] = $this->request->data['Customer']['suburb'];
                    $new_cus['Customer']['postcode'] = $this->request->data['Customer']['postcode'];
                    $new_cus['Customer']['city'] = $this->request->data['Customer']['city'];
                    $new_cus['Customer']['email'] = $this->request->data['Customer']['email'];
                    $new_cus['Customer']['mobile'] = $this->request->data['Customer']['mobile'];
                    $new_cus['Customer']['phone'] = $this->request->data['Customer']['phone'];
                    $new_cus['Customer']['id_proof'] = $this->request->data['Customer']['id_proof'];
                    $new_cus['Customer']['id_no'] = $this->request->data['Customer']['id_no'];

                    $new_cus['Customer']['created'] = $date_time;
                    $new_cus['Customer']['modified'] = $date_time;
                    $all_good = $this->Customer->save($new_cus);
                    $cust_id = $this->Customer->id;
                    $this->request->data['SalesEntry']['cus_id'] = $cust_id;
                } else {
                    $all_good = true;
                }

                if($all_good) {
                    $this->loadModel('SalesEntryAltered');                    

                    $status_changed = false;
                    $f_status = ($this->request->data['SalesEntry']['s_status'] == 1) ? 0 : 1;

                    if($f_status != $s_status) {
                        $status_changed = true;
                    }

                    //var_dump($data); //var_dump($this->request->data);

                    $sales_keys = array(
                        'user_id'                   => 'Sales Person',
                        'cus_id'                    => 'Customer',
                        'added_date'                => 'Sales Date',
                        'product_id'                => 'Product',
                        'setup_other_fees'          => 'Setup / Other Fees',
                        'payment_frequency'         => 'Payment Frequency',
                        'amount_per_payment'        => 'Amount Per Payment',
                        'number_of_payment'         => 'No. of Payment',
                        'initial_payment'           => 'Initial Payment',
                        'mop'                       => 'Payment Mode',
                        'payment_detail'            => 'Payment Detail',
                        'total_payment'             => 'Total Payment',
                        'payment_start_date'        => 'Payment Start Date',
                        'product_delivery_date'     => 'Product Delivery Date',
                        'tracking_no'               => 'Tracking No.',
                        'comments'                  => 'Comments',
                        'sign'                      => 'Form Signed',
                        'promo_1'                   => 'Promo 1',
                        'promo_2'                   => 'Promo 2',
                        'promo_3'                   => 'Promo 3',
                        'sales_form'                => 'Sales Form',
                        'ap_form'                   => 'AP Form',
                        'recurring_ap_form'         => 'Recurring AP Form',
                        'cancellation_form'         => 'Cancellation Form',
                        'email_comm_form_1'         => 'Email Communication Form 1',
                        'email_comm_form_2'         => 'Email Communication Form 2',
                        'delivery_status'           => 'Delivery Status',
                        'plan_id'                   => 'Plan ID' 
                        //'commission_status'         => 'Commission Status'
                    );
                    $altered_note = '';

                    if($this->SalesEntry->save($this->request->data)) {
                        if($this->SalesEntry->getAffectedRows()) {
                            $all_sales_person = $this->User->find('list');
                            $altered = $data['SalesEntry'];
                            unset($altered['id']);
                            $altered['created'] = $date_time;
                            $this->SalesEntryAltered->save($altered);
                            
                            $after_save = array(
                                'modified' => $date_time,
                                'status'   => 2
                            );
                            $this->SalesEntry->save($after_save);  

                            foreach($sales_keys as $k => $v) {
                                $old = $data['SalesEntry'][$k];
                                $new = $this->request->data['SalesEntry'][$k];
                                if($old != $new) {
                                    if($k == 'user_id') {
                                        $old = (!empty($old)) ? $all_sales_person[$old] : $old;
                                        $new = (!empty($new)) ? $all_sales_person[$new] : $new;
                                    }
                                    if($k == 'product_id') {
                                        $old = (!empty($old)) ? $products[$old] : $old;
                                        $new = (!empty($new)) ? $products[$new] : $new;
                                    }
                                    if($k == 'payment_detail') {
                                        if(!empty($old)) { $old = $this->one_line_pay_detail($this->get_payment_detail($old)); }
                                        $new = $this->one_line_pay_detail($this->get_payment_detail($new));
                                    }
                                    
                                    if($k == 'sign') {
                                        $old = $this->sign_form[$old];
                                        $new = $this->sign_form[$new];
                                    }
                                    if($k == 'delivery_status') {
                                        $old = $this->d_status[$old];
                                        $new = $this->d_status[$new];
                                    }
                                    if(in_array($k, array('added_date', 'payment_start_date', 'product_delivery_date'))) {
                                        if($old != '0000-00-00') {
                                            $old = new DateTime($old);
                                            $old = $old->format('d-m-Y');
                                        } else { $old = '00-00-0000'; }
                                        if($new != '0000-00-00') {
                                            $new = new DateTime($new);
                                            $new = $new->format('d-m-Y');
                                        } else { $new = '00-00-0000'; }
                                    }
                                    $altered_note .= '[<strong>'.$v.'</strong> is changed] <strong>OLD:</strong> '.$old.' => <strong>NEW:</strong> '.$new."\n";
                                }
                            }
                            $altered_note = substr($altered_note, 0, -1); 
                            $this->save_note($this->request->data['SalesEntry']['client_no'], $altered_note);                  
                        }

                        if($status_changed) {
                            if($s_status == 0) {
                                $sea_client = $this->SalesEntryAltered->hasAny(array('SalesEntryAltered.client_no' => $data['SalesEntry']['client_no']));
                                if($sea_client) {
                                    $stored_status = 2;
                                } else {
                                    $stored_status = 1;
                                }
                            } else {
                                $stored_status = 0;
                            }
                            $after_save = array(
                                'modified' => $date_time,
                                'status'   => $stored_status
                            );
                            $this->SalesEntry->save($after_save);
                            $this->save_note($this->request->data['SalesEntry']['client_no'], $this->request->data['SalesEntry']['cancellation_note']);
                        }

                        $this->Session->setFlash('The sales entry has been saved.', 'admin_msg_good');
                        return $this->redirect(array('action' => 'index'));
                    } else {
                        $this->Session->setFlash('something went wrong, please try again letter.', 'admin_msg_bad');
                    }
                } else {
                    $this->Session->setFlash('something went wrong, please try again letter.', 'admin_msg_bad');
                }                
            }
        }        

        $data['SalesEntry']['s_status'] = ($s_status == 0) ? 1 : 0;

        if(!$this->request->data) {
            $this->request->data = $data;
        }
        
        if($edit) {

            $ptd = $this->get_payment_detail($this->request->data['SalesEntry']['payment_detail']);

            $this->request->data['SalesEntry']['ac_no'] = $ptd['ac_no'];
            $this->request->data['SalesEntry']['cd_no'] = $ptd['cd']['cd_no'];
            $this->request->data['SalesEntry']['cd_month'] = $ptd['cd']['cd_month'];
            $this->request->data['SalesEntry']['cd_year'] = $ptd['cd']['cd_year'];
            $this->request->data['SalesEntry']['cvv'] = $ptd['cd']['cvv'];
        }
    }

    protected function one_line_pay_detail($ptd) {
        $pay_detail = '<u>A/C No.</u>: '.$ptd['ac_no'];
        $pay_detail .= '<u>Card No.</u>: '.$ptd['cd']['cd_no'];
        $pay_detail .= '<u>Month/Year:</u> '.$ptd['cd']['cd_month'].'/'.$ptd['cd']['cd_year'];
        $pay_detail .= '<u>CVV:</u> '.$ptd['cd']['cvv'];
        return $pay_detail;
    }

    protected function save_note($client, $note) {
        $this->loadModel('CustomerNotes');
        $note_to_be_saved = array(
            'user_id'   => $this->Session->read('userData.id'),
            'client_no' => $client,
            'notes'     => $note,
            'created'   => date('Y-m-d H:i:s')
        );
        $this->CustomerNotes->save($note_to_be_saved);
    }


    public function delete()
    {
        if (!empty($_POST)) {
            foreach ($_POST['delete_all'] as $key => $val) {
                $this->SalesEntry->delete($val);

            }
            $this->Session->setFlash('Sales Entry Deleted Sucessfully', 'admin_msg_good');
            return $this->redirect(array('action' => 'index'));
        }
    }

    public function getClient() {

        $this->render = false;
        $this->layout = 'ajax';
        if($this->request->is('ajax')) {
            $name = $this->request->data('name');
            $dob = $this->request->data('dob');

            $cus = $this->Customer->find('all', array(
                'conditions' => array('AND' => array(
                    'Customer.name LIKE ' => $name,
                    'Customer.dob LIKE ' => $dob
                ))
            ));

            $customer = array();

            if(!empty($cus)) {
                $customer = array(
                    'id'        => $cus[0]['Customer']['id'],
                    'name'      => $cus[0]['Customer']['name'],
                    'dob'       => $cus[0]['Customer']['dob'],
                    'email'     => $cus[0]['Customer']['email'],
                    'sno'       => $cus[0]['Customer']['street_no'],
                    'sname'     => $cus[0]['Customer']['street_name'],
                    'suburb'    => $cus[0]['Customer']['suburb'],
                    'postcode'  => $cus[0]['Customer']['postcode'],
                    'city'      => $cus[0]['Customer']['city'],
                    'phone'     => $cus[0]['Customer']['phone'],
                    'mobile'    => $cus[0]['Customer']['mobile'],
                    'id_proof'  => $cus[0]['Customer']['id_proof'],
                    'id_no'     => $cus[0]['Customer']['id_no']
                );
            } else {
                $customer = $cus;
            }

            echo json_encode($customer);
        }
        exit;
    }

    function check_client_no() {
        $this->render = false;
        $this->layout = 'ajax';
        if($this->request->is('ajax')) {
            $client = $this->request->data('client');
            $is_client = $this->SalesEntry->findByClientNo($client, array('fields' => 'client_no')); 
            echo (empty($is_client)) ? false : true;
        }
        exit;
    }

    function check_cus_name() {
        $this->render = false;
        $this->layout = 'ajax';
        if($this->request->is('ajax')) {
            $cus = $this->request->data('cus');
            $is_cus = $this->SalesEntry->findByCustomerName($cus, array('fields' => 'customer_name')); 
            echo (empty($is_cus)) ? false : true;
        }
        exit;
    }

    function get_product_detail()
    {
        $this->render = false;
        $this->layout = 'ajax';
        if($this->request->is('ajax')) {
            $pro_id = $this->request->data('product_id');
            $result = $this->Product->findById($pro_id);
            echo $result['Product']['price'];
        }
        exit;
    }

    private $c_notes;

    function reports() {

        $suburbs = array('all_suburbs' => 'All Suburbs');
        $all_suburb = $this->Customer->find('all', array(
                    'fields'    => 'DISTINCT (Customer.suburb)',
                    'order'     => 'Customer.suburb ASC'
               ));
        foreach($all_suburb as $s) {
            if(!empty($s['Customer']['suburb'])) {
                $suburbs[] = $s['Customer']['suburb'];
            }
        }

        $cities = array('all_cities' => 'All Cities');
        $all_cities = $this->Customer->find('all', array(
                    'fields'    => 'DISTINCT (Customer.city)',
                    'order'     => 'Customer.city ASC'
               ));
        foreach($all_cities as $c) {
            if(!empty($c['Customer']['city'])) {
                $cities[] = $c['Customer']['city'];
            }
        }

        $suburbs = array_combine($suburbs, $suburbs);
        $cities = array_combine($cities, $cities);

        $this->set('suburbs', $suburbs);
        $this->set('cities', $cities);

        $all_products = $this->Product->find('all', array('fields' => array('id', 'name', 'color', 'status')));
        $products = array('all_products' => 'All Products');
        foreach ($all_products as $key => $value) {
            $products[$value['Product']['id']] = $value['Product']['name'].' ('.$value['Product']['color'].')';
            if(!$value['Product']['status']) {
                $products[$value['Product']['id']] .= ' - [inactive]';
            }
        }
        $this->set('products', $products);

        $sales_person = $this->User->find('list', array('conditions' => array('User.group_id' => 4, 'User.status' => 1)));
        $this->set('agents', $sales_person);

        $tl_list = $this->User->find('list', array('conditions' => array('User.group_id' => 3, 'User.status' => 1)));
        $this->set('tls', $tl_list);

        if($this->request->is('post')) {
            $this->loadModel('InstallmentDetail');
            $this->loadModel('CustomerNotes');
            $report_group = '';
            $report = '';
            $start = $this->request->data['SalesEntry']['start'];
            $end = $this->request->data['SalesEntry']['end'];
            $report = (isset($this->request->data['SalesEntry']['reports'])) ? $this->request->data['SalesEntry']['reports'] : false;
            $report_option = (isset($this->request->data['SalesEntry']['report_options'])) ? $this->request->data['SalesEntry']['report_options'] : false;
            $default_date = $this->request->data['SalesEntry']['default_date'];

            $cond = array();
            $date_cond['SalesEntry.added_date >='] = $start;
            $date_cond['SalesEntry.added_date <='] = $end;

            if($report == 'agent_all_area') {
                $report_group = 'agent';
                $order = array('User.name' => 'ASC', 'Customer.suburb' => 'ASC', 'Customer.city' => 'ASC');
            
            } elseif($report == 'agent_area') {
                $report_group = 'agent';
                $suburb = $this->request->data['SalesEntry']['agent_suburbs'];
                if(!empty($suburb)) {
                    $is_as = array_search('All Suburbs', $suburb);
                    if(is_int($is_as)) {
                        unset($suburb[$is_as]);
                    }
                    $cond['Customer.suburb'] = $suburb;
                }
                $city = $this->request->data['SalesEntry']['agent_cities'];
                if(!empty($city)) {
                    $is_ac = array_search('All Cities', $city);
                    if(is_int($is_ac)) {
                        unset($city[$is_ac]);
                    }
                    $cond['Customer.city'] = $city;
                }

                $order = array('User.name' => 'ASC', 'Customer.suburb' => 'ASC', 'Customer.city' => 'ASC');
                
            } elseif($report == 'only_amount') {
                $report_group = 'amount';
                $from = $this->request->data['SalesEntry']['amount_from'];
                $to = $this->request->data['SalesEntry']['amount_to'];
                $client = $this->InstallmentDetail->query(
                    "SELECT `InstallmentDetail`.`sales_code`, SUM(`InstallmentDetail`.`amount`) AS `total`
                    FROM `installment_details` AS `InstallmentDetail`
                    GROUP BY `InstallmentDetail`.`sales_code`
                    HAVING `total` >= {$from} AND `total` <= {$to}
                    ORDER BY `total` ASC");

                foreach($client as $k => $c) {
                    $client[$k] = $c['InstallmentDetail']['sales_code'];
                    $ct[$c['InstallmentDetail']['sales_code']] = $c[0]['total'];
                }

                $order = array('SalesEntry.client_no' => 'ASC');
                $cond['SalesEntry.client_no'] = $client;
                

                if(isset($this->request->data['SalesEntry']['amount_with_area'])) {
                    $awa = $this->request->data['SalesEntry']['amount_with_area'];
                    if($awa == 'amount_with_area') {
                        $suburb = $this->request->data['SalesEntry']['amount_suburbs'];
                        if(!empty($suburb)) {
                            $is_as = array_search('All Suburbs', $suburb);
                            if(is_int($is_as)) {
                                unset($suburb[$is_as]);
                            }
                            $cond['Customer.suburb'] = $suburb;
                        }
                        $city = $this->request->data['SalesEntry']['amount_cities'];
                        if(!empty($city)) {
                            $is_ac = array_search('All Cities', $city);
                            if(is_int($is_ac)) {
                                unset($city[$is_ac]);
                            }
                            $cond['Customer.city'] = $city;
                        }
                    }
                }

            } elseif($report == 'all_area') {
                $report_group = 'area';
                $order = array('Customer.suburb' => 'ASC', 'Customer.city' => 'ASC');

                if(isset($this->request->data['SalesEntry']['area_product'])) {
                    $ap = $this->request->data['SalesEntry']['area_product'];
                    if($ap == 'area_product') {
                        $a_products = $this->request->data['SalesEntry']['area_products'];
                        if(!empty($a_products)) {
                            $is_ap = array_search('All Products', $a_products);
                            if(is_int($is_ap)) {
                                unset($a_products[$is_ap]);
                            }
                            $cond['SalesEntry.product_id'] = $a_products;
                        }
                    }
                }
            
            } elseif($report == 'select_area') {
                $report_group = 'area';
                $order = array('Customer.suburb' => 'ASC', 'Customer.city' => 'ASC');

                if(isset($this->request->data['SalesEntry']['area_agent'])) {
                    $aa = $this->request->data['SalesEntry']['area_agent'];
                    if($aa == 'area_agent') {
                        $a_agents = $this->request->data['SalesEntry']['area_agents'];
                        if(!empty($a_agents)) {
                            $is_aa = array_search('All Agents', $a_agents);
                            if(is_int($is_aa)) {
                                unset($a_agents[$is_aa]);
                            }
                            $cond['SalesEntry.user_id'] = $a_agents;
                        }
                    }
                }
                if(isset($this->request->data['SalesEntry']['area_tl'])) {
                    $atl = $this->request->data['SalesEntry']['area_tl'];
                    if($atl == 'area_tl') {
                        $a_tls = $this->request->data['SalesEntry']['area_tls'];
                        if(!empty($a_tls)) {
                            $is_atl = array_search('All Team Leaders', $a_tls);
                            if(is_int($is_atl)) {
                                unset($a_tls[$is_atl]);
                            }
                            $cond['SalesEntry.tl_id'] = $a_tls;
                        }
                    }
                }

                $suburb = $this->request->data['SalesEntry']['area_suburbs'];
                if(!empty($suburb)) {
                    $is_as = array_search('All Suburbs', $suburb);
                    if(is_int($is_as)) {
                        unset($suburb[$is_as]);
                    }
                    $cond['Customer.suburb'] = $suburb;
                    
                }
                $city = $this->request->data['SalesEntry']['area_cities'];
                if(!empty($city)) {
                    $is_ac = array_search('All Cities', $city);
                    if(is_int($is_ac)) {
                        unset($city[$is_ac]);
                    }
                    $cond['Customer.city'] = $city;
                }
            
            } elseif($report_option == 'active_clients') {
                
                $report_group = 'active_clients';

                $clients = $this->InstallmentDetail->query(
                    "SELECT DISTINCT `InstallmentDetail`.`sales_code`
                    FROM `installment_details` AS `InstallmentDetail`
                    WHERE month(`InstallmentDetail`.`date`) = {$this->request->data['SalesEntry']['active_mm']} AND year(`InstallmentDetail`.`date`) = {$this->request->data['SalesEntry']['active_yy']}
                    ORDER BY `InstallmentDetail`.`sales_code` ASC");

                $order = array('SalesEntry.client_no' => 'ASC');
                $cond['SalesEntry.client_no'] = array_values(Set::flatten($clients));
                $date_cond = [];

            } elseif($report_option == 'history_notes') {
                
                $report_group = 'history_notes';

                $from_mm = $this->request->data['SalesEntry']['history_f_mm'];
                $from_yy = $this->request->data['SalesEntry']['history_f_yy'];
                $to_mm = $this->request->data['SalesEntry']['history_t_mm'];
                $to_yy = $this->request->data['SalesEntry']['history_t_yy'];

                $notes = $this->CustomerNotes->query(
                    "SELECT `CustomerNotes`.*, `users`.`name`
                    FROM `customer_notes` AS `CustomerNotes`
                    JOIN `users` ON `CustomerNotes`.`user_id` = `users`.`id`
                    WHERE DATE_FORMAT(`CustomerNotes`.`created`, '%Y%m') BETWEEN {$from_yy}{$from_mm} AND {$to_yy}{$to_mm}
                    ORDER BY `CustomerNotes`.`id` ASC");

                foreach($notes as $n) {
                    $cn = $n['CustomerNotes'];
                    $cn['name'] = $n['users']['name'];
                    $clients[] = $cn['client_no'];
                    $this->c_notes[$cn['client_no']][] = $cn;
                }                

                $order = array('SalesEntry.client_no' => 'ASC');
                $cond['SalesEntry.client_no'] = $clients;
                $date_cond = [];

            } else {
                $date_cond['SalesEntry.added_date >='] = '1970-01-01';
                $date_cond['SalesEntry.added_date <='] = date('Y-m-d');
                $order = array('SalesEntry.added_date ASC');
            }

            if($default_date) {
                $conditions['AND'] = array(
                    $cond,
                    'OR' => array(
                        'SalesEntry.added_date' => '1970-01-01',
                        $date_cond
                    )
                );
            } else { 
                $conditions['AND'] = ($cond + $date_cond);
            }

            $is_data = true;
            $page = 0;
            $results = array();

            while($is_data) {
                $page++;
                $paged_result = $this->SalesEntry->find('all', array(
                    'fields'    => array('SalesEntry.id', 'SalesEntry.tl_id', 'SalesEntry.user_id', 'SalesEntry.cus_id',
                            'SalesEntry.client_no', 'DATE_FORMAT(SalesEntry.added_date, "%d-%m-%Y") AS ad', 'SalesEntry.product_id', 'SalesEntry.setup_other_fees',
                            'SalesEntry.payment_frequency', 'SalesEntry.amount_per_payment', 'SalesEntry.initial_payment',
                            'SalesEntry.mop', 'SalesEntry.payment_detail', 'SalesEntry.total_payment', 'DATE_FORMAT(SalesEntry.payment_start_date, "%d-%m-%Y") AS psd',
                            'DATE_FORMAT(SalesEntry.product_delivery_date, "%d-%m-%Y") AS pdd', 'SalesEntry.comments', 'SalesEntry.promo_1', 'SalesEntry.promo_2',
                            'SalesEntry.promo_3', 'SalesEntry.delivery_status', 'SalesEntry.commission_status',
                            'Customer.*', 'DATE_FORMAT(Customer.dob, "%d-%m-%Y") AS dob', 'Product.name', 'Product.color', 'User.name', 'TL.name'),
                    'conditions'=> $conditions,
                    'order'     => $order,
                    'page'      => $page,
                    'limit'     => 500
                    ));
                if(empty($paged_result)) {
                    break;
                } else {
                    foreach($paged_result as $k => $v) {
                        if(!empty($v['SalesEntry']['client_no'])) {
                            /*$total = $this->InstallmentDetail->query(
                            "SELECT SUM(`InstallmentDetail`.`amount`) AS `total`
                            FROM `installment_details` AS `InstallmentDetail`
                            WHERE `InstallmentDetail`.`sales_code` = {$v['SalesEntry']['client_no']}");*/
                            
                            $total_count = $this->InstallmentDetail->find('all', array('fields' => array('SUM(InstallmentDetail.amount) AS total', 'count(InstallmentDetail.sales_code) as count'), 'conditions'=>array('InstallmentDetail.sales_code' => $v['SalesEntry']['client_no'])));
                            
                            $paged_result[$k]['paid'] = $total_count[0][0]['total'];
                            $paged_result[$k]['pay_count'] = $total_count[0][0]['count'];
                            $paged_result[$k]['remaining'] = $v['SalesEntry']['total_payment'] - $v['SalesEntry']['initial_payment'] - $total_count[0][0]['total'];                                                          
                        } else {
                            $paged_result[$k]['paid'] = 0;
                            $paged_result[$k]['pay_count'] = 0;
                            $paged_result[$k]['remaining'] = 0;
                        }
                    }

                    $results = array_merge($results, $paged_result);
                }
            }

            if(!$report) { $final_result = $results; }

            if($report_group == 'agent') {
                $report_filename = 'Agent Wise Ledger';
                $parent = $sales_person;
            
                foreach($parent as $key => $value) {                
                    foreach($results as $k => $r) {
                        if($r['SalesEntry']['user_id'] == $key) {
                            $final_result[$key][] = $r;
                            unset($results[$k]);
                        }
                    }
                }
            }         
            
            if($report_group == 'amount') {
                $report_filename = '$'.$from.' - $'.$to.' Ledger';

                $c = 3;
                $f = $from;
                $r = $from;
                while($r < $to) {
                    $r += (100*$c);
                    if($r < $to) {
                        $parent[] = $f.'-'.$r;
                    } else {
                        $parent[] = $f.'-'.$to;
                    }
                    $f = $r+1;
                }//var_dump($results);

                foreach($results as $k => $r) {
                    if(isset($ct[$r['SalesEntry']['client_no']])) {
                        $r_total = (int)$ct[$r['SalesEntry']['client_no']];

                        foreach($parent as $p) {
                            $f_t = explode('-', $p);
                            if($r_total >= $f_t[0] && $r_total <= $f_t[1]) {
                                $final_result[$p][] = $r;
                                unset($results[$k]);
                                break;
                            }
                        }
                    }
                }
                $parent = array_combine($parent, $parent);
            }   

            if($report_group == 'area') {
                $report_filename = 'Area Wise Ledger';
                $parent = $suburbs;
                unset($parent['All Suburbs']);
                foreach($parent as $s) {
                    foreach ($results as $key => $value) {
                        if($value['Customer']['suburb'] == $s) {
                            $final_result[$s][] = $value;
                            unset($results[$key]);
                        } elseif(empty($value['Customer']['suburb'])) {
                            $final_result['No Suburbs'][] = $value;
                            unset($results[$key]);                            
                        }
                    }
                }
            }  

            if($report_group == 'active_clients') {
                $report = true;
                $report_filename = 'Active Clients';
                $parent = ['ac' => 'Active Clients - '. $this->request->data['SalesEntry']['active_mm'] .'-'. $this->request->data['SalesEntry']['active_yy']];
                $final_result = [];
                $final_result['ac'] = $results;
                unset($results);
            }  

            if($report_group == 'history_notes') {
                $report = true;
                $report_filename = 'History Notes';
                $parent = ['hn' => $this->request->data['SalesEntry']['history_f_mm'] .'-'. $this->request->data['SalesEntry']['history_f_yy'] .' -- '. $this->request->data['SalesEntry']['history_t_mm'] .'-'. $this->request->data['SalesEntry']['history_t_yy']];
                $final_result = [];
                $final_result['hn'] = $results;
                unset($results);
            }

            if(!empty($final_result)) {//var_dump($final_result);
                if($report) {
                    $this->reports_parameters($final_result, $parent, $report_filename);
                } else {
                    $this->reports_all($final_result);
                }        
            } else {
                $this->Session->setFlash('No records were found.', 'admin_msg_bad');
            }
        }
    }

    // define table cells
    private $table = array(
        array('label' => 'Client Number', 'width' => 15),
        array('label' => 'Name', 'width' => 30),
        array('label' => 'Birthdate', 'width' => 12),
        array('label' => 'Street No.', 'width' => 15),
        array('label' => 'Street Name', 'width' => 15),
        array('label' => 'Suburb', 'width' => 15),
        array('label' => 'City', 'width' => 15),
        array('label' => 'Postcode', 'width' => 15),
        array('label' => 'Landline', 'width' => 15),
        array('label' => 'Mobile No.', 'width' => 15),
        array('label' => 'Added Date', 'width' => 15),
        array('label' => 'Sales Week', 'width' => 15),
        array('label' => 'Start Date', 'width' => 15),
        array('label' => 'Tablet Size & Name', 'width' => 30),
        array('label' => 'Color', 'width' => 15),
        array('label' => 'Price of Tablet', 'width' => 15),
        array('label' => 'Promo', 'width' => 40, 'wrap' => true),
        array('label' => 'Frequency', 'width' => 15),
        array('label' => 'Amount Per Payment', 'width' => 15),
        array('label' => 'Mode of Payment', 'width' => 15),
        array('label' => 'Adv/Lumpsum Payment', 'width' => 15),
        array('label' => 'Bank Account Detail', 'width' => 30, 'wrap' => true),
        array('label' => 'Agent Asigned', 'width' => 15),
        array('label' => 'Team Leader', 'width' => 15),
        array('label' => 'Payments Count', 'width' => 15),
        array('label' => 'Total Payment Received', 'width' => 15),
        array('label' => 'Account Balance', 'width' => 15),
        array('label' => 'Commission Paid', 'width' => 15),
        array('label' => 'Delivery Status', 'width' => 15),
        array('label' => 'Delivery Date', 'width' => 12)
    );

    private function reports_parameters($final_result, $parent, $report_filename) {
        //var_dump(count($final_result));
        $this->PhpExcel->createWorksheet()->setDefaultFont('Calibri', 12);
        $this->PhpExcel->removeSheetByIndex(0);

        foreach($parent as $key => $value) {
            
            if(isset($final_result[$key])) {

                if($key == 'hn') {
                    $this->table[] = ['label' => 'Notes', 'width' => 100, 'wrap' => true];
                }

            $value = str_replace(array('\'', '"'), '', $value);
            $value = str_replace(array('\\', '/'), '-', $value);
            $this->PhpExcel->addSheet($value);
            $this->PhpExcel->addTableHeader($this->table, array('name' => 'Cambria', 'bold' => true));                
            //sleep(1);
            // add data
            foreach($final_result[$key] as $r) {

                $sales_week = 0;
                if(!empty($r[0]['ad'])) {
                    $date = new DateTime($r[0]['ad']);
                    $sales_week = $date->format('W');
                }

                $promo = 'Promo 1: '.$r['SalesEntry']['promo_1']."\n";
                $promo .= 'Promo 2: '.$r['SalesEntry']['promo_2']."\n";
                $promo .= 'Promo 3: '.$r['SalesEntry']['promo_3']."\n";
                $promo .= 'Comments: '.$r['SalesEntry']['comments'];

                $ptd = $this->get_payment_detail($r['SalesEntry']['payment_detail']);

                $pay_detail = 'A/C No.: '.$ptd['ac_no']."\n\n";
                $pay_detail .= 'Card No.: '.$ptd['cd']['cd_no']."\n";
                $pay_detail .= 'Month/Year: '.$ptd['cd']['cd_month'].'/'.$ptd['cd']['cd_year']."\n";
                $pay_detail .= 'CVV: '.$ptd['cd']['cvv'];

                if($key == 'hn') {

                    $r_note = '';

                    foreach($this->c_notes[$r['SalesEntry']['client_no']] as $cn) {
                        $r_date = date_format(date_create($cn['created']), 'j-M-Y g:i:s a');

                        $r_note .= $r_date."\n";
                        $r_note .= $cn['name'].': ';
                        $r_note .= str_replace(['<strong>', '</strong>', '<u>', '</u>'], '', $cn['notes']);
                        $r_note .= "\n\n";
                    }                    

                    $table_row = [
                        $r['SalesEntry']['client_no'],
                        $r['Customer']['name'],
                        $r[0]['dob'],
                        $r['Customer']['street_no'],
                        $r['Customer']['street_name'],
                        $r['Customer']['suburb'],
                        $r['Customer']['city'],
                        $r['Customer']['postcode'],
                        $r['Customer']['phone'],
                        $r['Customer']['mobile'],
                        $r[0]['ad'],
                        $sales_week,
                        $r[0]['psd'],
                        $r['Product']['name'],
                        $r['Product']['color'],
                        $r['SalesEntry']['total_payment'],
                        $promo,
                        $r['SalesEntry']['payment_frequency'],
                        $r['SalesEntry']['amount_per_payment'],
                        $r['SalesEntry']['mop'],
                        $r['SalesEntry']['initial_payment'],
                        $pay_detail,
                        $r['User']['name'],
                        $r['TL']['name'],
                        $r['pay_count'],
                        $r['paid'],
                        $r['remaining'],
                        $this->c_status[$r['SalesEntry']['commission_status']],
                        $this->d_status[$r['SalesEntry']['delivery_status']],
                        $r[0]['pdd'],
                        $r_note
                    ];

                } else {

                    $table_row = [
                        $r['SalesEntry']['client_no'],
                        $r['Customer']['name'],
                        $r[0]['dob'],
                        $r['Customer']['street_no'],
                        $r['Customer']['street_name'],
                        $r['Customer']['suburb'],
                        $r['Customer']['city'],
                        $r['Customer']['postcode'],
                        $r['Customer']['phone'],
                        $r['Customer']['mobile'],
                        $r[0]['ad'],
                        $sales_week,
                        $r[0]['psd'],
                        $r['Product']['name'],
                        $r['Product']['color'],
                        $r['SalesEntry']['total_payment'],
                        $promo,
                        $r['SalesEntry']['payment_frequency'],
                        $r['SalesEntry']['amount_per_payment'],
                        $r['SalesEntry']['mop'],
                        $r['SalesEntry']['initial_payment'],
                        $pay_detail,
                        $r['User']['name'],
                        $r['TL']['name'],
                        $r['pay_count'],
                        $r['paid'],
                        $r['remaining'],
                        $this->c_status[$r['SalesEntry']['commission_status']],
                        $this->d_status[$r['SalesEntry']['delivery_status']],
                        $r[0]['pdd']
                    ];
                }

                $this->PhpExcel->addTableRow($table_row);
            }
            $active_sheet = $this->PhpExcel->getActiveSheet();
            $active_sheet->getStyle('Q1:Q'.$active_sheet->getHighestRow())->getAlignment()->setWrapText(true);
            $active_sheet->getStyle('V1:V'.$active_sheet->getHighestRow())->getAlignment()->setWrapText(true);

            }
        }
        $this->PhpExcel->setActiveSheet(0);
        // close table and output
        $this->PhpExcel->addTableFooter()->output($report_filename.' - '.date('d-m-Y H:i:s').'.xlsx')->freeMemory();
    }

    private function reports_all($results) {

        $this->PhpExcel->createWorksheet()->setDefaultFont('Calibri', 12);

        $this->PhpExcel->addTableHeader($this->table, array('name' => 'Cambria', 'bold' => true));
        
        foreach($results as $key => $r) {

            $sales_week = 0;
            if(!empty($r[0]['ad'])) {
                $date = new DateTime($r[0]['ad']);
                $sales_week = $date->format('W');
            }

            $promo = 'Promo 1: '.$r['SalesEntry']['promo_1']."\n";
            $promo .= 'Promo 2: '.$r['SalesEntry']['promo_2']."\n";
            $promo .= 'Promo 3: '.$r['SalesEntry']['promo_3']."\n";
            $promo .= 'Comments: '.$r['SalesEntry']['comments'];

            $ptd = $this->get_payment_detail($r['SalesEntry']['payment_detail']);

            $pay_detail = 'A/C No.: '.$ptd['ac_no']."\n\n";
            $pay_detail .= 'Card No.: '.$ptd['cd']['cd_no']."\n";
            $pay_detail .= 'Month/Year: '.$ptd['cd']['cd_month'].'/'.$ptd['cd']['cd_year']."\n";
            $pay_detail .= 'CVV: '.$ptd['cd']['cvv'];

            $this->PhpExcel->addTableRow(array(
                    $r['SalesEntry']['client_no'],
                    $r['Customer']['name'],
                    $r[0]['dob'],
                    $r['Customer']['street_no'],
                    $r['Customer']['street_name'],
                    $r['Customer']['suburb'],
                    $r['Customer']['city'],
                    $r['Customer']['postcode'],
                    $r['Customer']['phone'],
                    $r['Customer']['mobile'],
                    $r[0]['ad'],
                    $sales_week,
                    $r[0]['psd'],
                    $r['Product']['name'],
                    $r['Product']['color'],
                    $r['SalesEntry']['total_payment'],
                    $promo,
                    $r['SalesEntry']['payment_frequency'],
                    $r['SalesEntry']['amount_per_payment'],
                    $r['SalesEntry']['mop'],
                    $r['SalesEntry']['initial_payment'],
                    $pay_detail,
                    $r['User']['name'],
                    $r['TL']['name'],
                    $r['pay_count'],
                    $r['paid'],
                    $r['remaining'],
                    $this->c_status[$r['SalesEntry']['commission_status']],
                    $this->d_status[$r['SalesEntry']['delivery_status']],
                    $r[0]['pdd']
            ));
            //$this->PhpExcel->getActiveSheet()->getStyle('N1:N'.$this->PhpExcel->getActiveSheet()->getHighestRow())->getAlignment()->setWrapText(true);
            //$this->PhpExcel->getActiveSheet()->getStyle('S1:S'.$this->PhpExcel->getActiveSheet()->getHighestRow())->getAlignment()->setWrapText(true);
            
        }
        // close table and output
        $this->PhpExcel->addTableFooter()->output('All Records - '.date('d-m-Y H:i:s').'.xlsx');
    }

    /*function reports() {

        if($this->request->is('post')) {
            $this->loadModel('InstallmentDetail');
            $start = $this->request->data['SalesEntry']['start'];
            $end = $this->request->data['SalesEntry']['end'];
            $default_date = $this->request->data['SalesEntry']['default_date'];

            $cond = array();
            $cond['SalesEntry.added_date >='] = $start;
            $cond['SalesEntry.added_date <='] = $end;

            if($default_date) {
                $conditions['OR'] = array(
                    'SalesEntry.added_date' => '1970-01-01',
                    'AND' => $cond
                );
            } else { 
                $conditions['AND'] = $cond;
            }

            $is_data = true;
            $page = 0;
            $results = array();

            while($is_data) {
                $page++;
                $paged_result = $this->SalesEntry->find('all', array(
                    'conditions'=> $conditions,
                    'order'     => array('SalesEntry.client_no' => 'ASC'),
                    'page'      => $page,
                    'limit'     => 50
                    ));
                if(empty($paged_result)) {
                    $is_data = false;
                } else {
                    foreach($paged_result as $k => $v) {
                        if(!empty($v['SalesEntry']['client_no'])) {
                            $total = $this->InstallmentDetail->query(
                            "SELECT SUM(`InstallmentDetail`.`amount`) AS `total`
                            FROM `installment_details` AS `InstallmentDetail`
                            WHERE `InstallmentDetail`.`sales_code` = {$v['SalesEntry']['client_no']}");
                            
                            $paged_result[$k]['paid'] = $total[0][0]['total'];
                            $paged_result[$k]['pay_count'] = $this->InstallmentDetail->find('count', array('conditions' => array('InstallmentDetail.sales_code' => $v['SalesEntry']['client_no'])));
                            $paged_result[$k]['remaining'] = $v['SalesEntry']['total_payment'] - $v['SalesEntry']['initial_payment'] - $total[0][0]['total'];
                        } else {
                            $paged_result[$k]['paid'] = 0;
                            $paged_result[$k]['pay_count'] = 0;
                            $paged_result[$k]['remaining'] = 0;
                        }
                    }

                    $results = array_merge($results, $paged_result);
                }
            }

            if(!empty($results)) {

            $this->PhpExcel->createWorksheet()->setDefaultFont('Calibri', 12);

            // define table cells
            $table = array(
                array('label' => __('Client Number'), 'width' => 15),
                array('label' => __('Name'), 'width' => 30),
                array('label' => __('Birthdate'), 'width' => 12),
                array('label' => __('Street No.'), 'width' => 15),
                array('label' => __('Street Name'), 'width' => 15),
                array('label' => __('Suburb'), 'width' => 15),
                array('label' => __('City'), 'width' => 15),
                array('label' => __('Postcode'), 'width' => 15),
                array('label' => __('Landline'), 'width' => 15),
                array('label' => __('Mobile No.'), 'width' => 15),
                array('label' => __('Added Date'), 'width' => 15),
                array('label' => __('Sales Week'), 'width' => 15),
                array('label' => __('Start Date'), 'width' => 15),
                array('label' => __('Tablet Size & Name'), 'width' => 30),
                array('label' => __('Color'), 'width' => 15),
                array('label' => __('Price of Tablet'), 'width' => 15),
                array('label' => __('Promo'), 'width' => 40, 'wrap' => true),
                array('label' => __('Frequency'), 'width' => 15),
                array('label' => __('Amount Per Payment'), 'width' => 15),
                array('label' => __('Mode of Payment'), 'width' => 15),
                array('label' => __('Adv/Lumpsum Payment'), 'width' => 15),
                array('label' => __('Bank Account Detail'), 'width' => 30, 'wrap' => true),
                array('label' => __('Agent Asigned'), 'width' => 15),
                array('label' => __('Team Leader'), 'width' => 15),
                array('label' => __('Payments Count'), 'width' => 15),
                array('label' => __('Total Payment Received'), 'width' => 15),
                array('label' => __('Account Balance'), 'width' => 15),
                array('label' => __('Commission Paid'), 'width' => 15),
                array('label' => __('Delivery Status'), 'width' => 15),
                array('label' => __('Delivery Date'), 'width' => 12)
            );

            function change_date_format($date = '') {
                $new_format = '';
                if(!empty($date)) {
                    $date = new DateTime($date);
                    $new_format = $date->format('d-m-Y');
                }
                return $new_format;
            }

            $this->PhpExcel->addTableHeader($table, array('name' => 'Cambria', 'bold' => true));
            foreach($results as $key => $r) {
                $dob = change_date_format($r['Customer']['dob']);
                $added_date = change_date_format($r['SalesEntry']['added_date']);
                $payment_start_date = change_date_format($r['SalesEntry']['payment_start_date']);
                $product_delivery_date = change_date_format($r['SalesEntry']['product_delivery_date']);

                $sales_week = 0;
                if(!empty($r['SalesEntry']['added_date'])) {
                    $date = new DateTime($r['SalesEntry']['added_date']);
                    $sales_week = $date->format('W');
                }

                $promo = 'Promo 1: '.$r['SalesEntry']['promo_1']."\n";
                $promo .= 'Promo 2: '.$r['SalesEntry']['promo_2']."\n";
                $promo .= 'Promo 3: '.$r['SalesEntry']['promo_3']."\n";
                $promo .= 'Comments: '.$r['SalesEntry']['comments'];


                $ptd = $this->get_payment_detail($r['SalesEntry']['payment_detail']);

                $pay_detail = 'A/C No.: '.$ptd['ac_no']."\n\n";
                $pay_detail .= 'Card No.: '.$ptd['cd']['cd_no']."\n";
                $pay_detail .= 'Month/Year: '.$ptd['cd']['cd_month'].'/'.$ptd['cd']['cd_year']."\n";
                $pay_detail .= 'CVV: '.$ptd['cd']['cvv'];

                $this->PhpExcel->addTableRow(array(
                    $r['SalesEntry']['client_no'],
                    $r['Customer']['name'],
                    $dob,
                    $r['Customer']['street_no'],
                    $r['Customer']['street_name'],
                    $r['Customer']['suburb'],
                    $r['Customer']['city'],
                    $r['Customer']['postcode'],
                    $r['Customer']['phone'],
                    $r['Customer']['mobile'],
                    $added_date,
                    $sales_week,
                    $payment_start_date,
                    $r['Product']['name'],
                    $r['Product']['color'],
                    $r['SalesEntry']['total_payment'],
                    $promo,
                    $r['SalesEntry']['payment_frequency'],
                    $r['SalesEntry']['amount_per_payment'],
                    $r['SalesEntry']['mop'],
                    $r['SalesEntry']['initial_payment'],
                    $pay_detail,
                    $r['User']['name'],
                    $r['TL']['name'],
                    $r['pay_count'],
                    $r['paid'],
                    $r['remaining'],
                    $this->c_status[$r['SalesEntry']['commission_status']],
                    $this->d_status[$r['SalesEntry']['delivery_status']],
                    $product_delivery_date
                ));
                $this->PhpExcel->getActiveSheet()->getStyle('N1:N'.$this->PhpExcel->getActiveSheet()->getHighestRow())->getAlignment()->setWrapText(true);
                $this->PhpExcel->getActiveSheet()->getStyle('S1:S'.$this->PhpExcel->getActiveSheet()->getHighestRow())->getAlignment()->setWrapText(true);

            }
            // close table and output
            $this->PhpExcel->addTableFooter()->output('All Records - '.date('d-m-Y H:i:s').'.xlsx');
            } else {
                $this->Session->setFlash('No records found.', 'admin_msg_bad');
            }
        }
    }*/

    protected function set_payment_mode($data) {        
        $ptd = array();
        
        $ptd['ac'] = $data['SalesEntry']['ac_no'];
        $ptd['cd'] = serialize(array(
            'cd_no'     => $data['SalesEntry']['cd_no'],
            'cd_month'  => $data['SalesEntry']['cd_month'],
            'cd_year'   => $data['SalesEntry']['cd_year'],
            'cvv'       => $data['SalesEntry']['cvv']
        ));
        $ptd = serialize($ptd);
        $data['SalesEntry']['payment_detail'] = $ptd;
        return $data;
    }

    protected function get_payment_detail($ptd) {

        $ptd_check = @unserialize($ptd); 
        
        if($ptd === 'b:0;' || $ptd_check !== false) {
            $ptd = unserialize($ptd);
            if(array_key_exists('cd', $ptd)) {
                $ac_no = $ptd['ac'];
                $cd = unserialize($ptd['cd']);
            } else {
                $ac_no = '';
                $cd = $ptd;
            }
        } else {
            $ac_no = $ptd;
            $cd = array('cd_no' => '', 'cd_month' => '', 'cd_year' => '', 'cvv' => '');
        }
        return array(
            'ac_no' => $ac_no,
            'cd'    => $cd
        );
    }

    function download_file($dir, $filename) {
        $filenameParts = explode('.', $filename);
        $filenameExt = array_pop($filenameParts);
        $filenameBase = implode('.', $filenameParts);
        $this->viewClass = 'Media';
        $params = array(
            'id' => $filename,
            'name' => $filenameBase,
            'download' => true,
            'extension' => strtolower($filenameExt),
            'path' => APP . 'webroot'.DS.'files'. DS . $dir . DS,   // don't forget terminal 'DS'
            'cache' => true
        );
        $this->set($params);
    }

    function delete_file() {
        $this->render = false;
        $this->layout = 'ajax';
        $file = $this->request->data;
        
        $pdf = $this->SalesEntry->find('all', array('conditions' => array('SalesEntry.id' == $file['se']), 'fields' => array($file['form'].'_dir'))); 
        $pdf = $pdf[0]['SalesEntry'][$file['form'].'_dir'];
        if(file_exists(WWW_ROOT.$pdf)) {
            unlink(WWW_ROOT.$pdf);
        }
        $this->SalesEntry->id = $file['se'];
        $this->SalesEntry->saveField($file['form'],'No File');
        $this->SalesEntry->saveField($file['form'].'_dir','No File');
        echo 'done';
        exit;
    }

    /**
     * uploads files to the server
     * @params:
     *      $folder     = the folder to upload the files e.g. 'img/files'
     *      $formdata   = the array containing the form files
     * @return:
     *      will return an array with the success of each file upload
     */
    function uploadFiles($folder, $file, $new_file_name) {
        // setup dir names absolute and relative
        $folder_url = WWW_ROOT.$folder;
        $rel_url = $folder;
        
        // create the folder if it does not exist
        if(!is_dir($folder_url)) {
            mkdir($folder_url);
        }
        // replace spaces with underscores
        $filename = str_replace(' ', '_', $file['name']);
        // assume filetype is false
        $typeOK = false;
        // check filetype is ok
        if($file['type'] == 'application/pdf') {
            $typeOK = true;
        }
        
        // if file type ok upload the file
        if($typeOK) {
            // switch based on error code
            switch($file['error']) {
                case 0:
                    // check filename already exists
                    $success = false;
                    $full_url = $folder_url.'/'.$new_file_name.'.pdf';
                    if(!file_exists($full_url)) {
                        // create unique filename and upload file                        
                        $url = $rel_url.'/'.$new_file_name.'.pdf';
                        $success = move_uploaded_file($file['tmp_name'], $url);
                        $result['exists'] = false;
                    } else {
                        $result['exists'] = true;
                    }
                    // if upload was successful
                    if($success) {
                        // save the url of the file
                        $result['file']['name'] = $new_file_name.'.pdf';
                        $result['file']['url'] = $url;
                    } else {
                        $result['errors'][] = 'Error uploaded $filename. Please try again.';
                    }
                    break;
                case 3:
                    // an error occured
                    $result['errors'][] = 'Error uploading $filename. Please try again.';
                    break;
                default:
                    // an error occured
                    $result['errors'][] = 'System error uploading $filename. Contact webmaster.';
                    break;
            }
        } elseif($file['error'] == 4) {
            // no file was selected for upload
            $result['nofiles'][] = 'No file Selected';
        } else {
            // unacceptable file type
            $result['errors'][] = '$filename cannot be uploaded. Only PDF file can be uploaded.';
        }
    return $result;
    }

    function commission() {
        if($this->request->is('post')) {
            $file_name = $this->request->data['SalesEntry']['file']['name'];
            $filename = $this->request->data['SalesEntry']['file']['tmp_name'];
            $tempFile = new File($file_name);
            $ext = $tempFile->ext();
            $ext = strtolower($ext);
            $types = array('csv');
            $val = in_array($ext, $types, true);
            if($val) {
                // open the file
                $handle = fopen($filename, 'r');
                $data_arr = array();
                $counter = 0;
                while($row = fgetcsv($handle, 0, "\n")) {
                    if(!empty($row[0])) {
                        $se_id = $this->SalesEntry->findByClientNo($row[0], array('fields' => 'id'));
                        if(!empty($se_id)) {
                            $this->SalesEntry->save(array('id' => $se_id['SalesEntry']['id'], 'commission_status' => 1));
                            $counter++;
                        }
                    }
                }
                $this->Session->setFlash($counter.' products commision updated.', 'admin_msg_good');
                $this->render('/SalesEntry/commission');
            } else {
                $this->Session->setFlash('Please select csv file only.', 'admin_msg_bad');
                $this->render('/SalesEntry/commission');
            }
        }
    }

    function generated_invoice() {
        if($this->request->is('post')) {
            $file_name = $this->request->data['SalesEntry']['file']['name'];
            $filename = $this->request->data['SalesEntry']['file']['tmp_name'];
            $tempFile = new File($file_name);
            $ext = $tempFile->ext();
            $ext = strtolower($ext);
            $types = array('csv');
            $val = in_array($ext, $types, true);
            if($val) {
                // open the file
                $handle = fopen($filename, 'r');
                $data_arr = array();
                $counter = 0;
                while($row = fgetcsv($handle, 0, "\n")) {
                    if(!empty($row[0])) {
                        $se_id = $this->SalesEntry->findByClientNo($row[0], array('fields' => 'id'));
                        if(!empty($se_id)) {
                            $this->SalesEntry->save(array('id' => $se_id['SalesEntry']['id'], 'invoice_generated' => 1));
                            $counter++;
                        }
                    }
                }
                $this->Session->setFlash($counter.' generated invoice updated.', 'admin_msg_good');
                $this->render('/SalesEntry/generated_invoice');
            } else {
                $this->Session->setFlash('Please select csv file only.', 'admin_msg_bad');
                $this->render('/SalesEntry/generated_invoice');
            }
        }
    }

    function payrun() {

        if($this->request->is('post')) {

            $user_type = $this->request->data['user'];            
            $this->loadModel('InstallmentDetail');

            $user = array('group' => '', 'field' => '', 'type'  => '');

            if($user_type == 'tl') {
                $user = array(
                    'group' => 3,
                    'field' => 'tl_id',
                    'type'  => 'TL'
                ); 
            } elseif($user_type == 'sales_agent') {  
                $user = array(
                    'group' => 4,
                    'field' => 'user_id',
                    'type'  => 'User'
                );             
            }

            $this->PhpExcel->createWorksheet()->setDefaultFont('Calibri', 12);
            $this->PhpExcel->removeSheetByIndex(0);

            // define table cells
            $table = array(
                array('label' => __('Client Number'), 'width' => 15),
                array('label' => __('Name'), 'width' => 30),
                array('label' => __('Birthdate'), 'width' => 12),
                array('label' => __('Street No.'), 'width' => 15),
                array('label' => __('Street Name'), 'width' => 15),
                array('label' => __('Suburb'), 'width' => 15),
                array('label' => __('Landline'), 'width' => 15),
                array('label' => __('Mobile No.'), 'width' => 15),
                array('label' => __('City'), 'width' => 15),
                array('label' => __('Start Date'), 'width' => 15),
                array('label' => __('Tablet Size & Name'), 'width' => 30),
                array('label' => __('Color'), 'width' => 15),
                array('label' => __('Price of Tablet'), 'width' => 15),
                array('label' => __('Promo'), 'width' => 40, 'wrap' => true),
                array('label' => __('Sales Week'), 'width' => 15),
                array('label' => __('Frequency'), 'width' => 15),
                array('label' => __('Amount Per Payment'), 'width' => 15),
                array('label' => __('Mode of Payment'), 'width' => 15),
                array('label' => __('Adv/Lumpsum Payment'), 'width' => 15),
                array('label' => __('Bank Account Detail'), 'width' => 15),
                array('label' => __('Agent Asigned'), 'width' => 15),
                array('label' => __('Team Leader'), 'width' => 15),
                array('label' => __('Payments Count'), 'width' => 15),
                array('label' => __('Total Payment Received'), 'width' => 15),
                array('label' => __('Commission Paid'), 'width' => 15),
                array('label' => __('Status'), 'width' => 15),
                array('label' => __('Delivery Date'), 'width' => 12)
            );

            $user_list = $this->User->find('list', array('conditions' => array('User.group_id' => $user['group'])));
            
            if(!empty($user_list)) {
            foreach($user_list as $key => $value) {
                
                $sales_entry = $this->SalesEntry->find('all', array('conditions' => array('SalesEntry.'.$user['field'] => $key)));
                //var_dump($sales_entry);
                if(!empty($sales_entry)) {
                $this->PhpExcel->addSheet($sales_entry[0][$user['type']]['name']);
                $this->PhpExcel->addTableHeader($table, array('name' => 'Cambria', 'bold' => true));                
                    // add data
                    foreach($sales_entry as $se) {

                        $installments = $this->InstallmentDetail->find('all', array('conditions' => array('InstallmentDetail.sales_code' => $se['SalesEntry']['client_no'])));
                        
                        $installmets_total = 0;
                        foreach($installments as $key => $value) {
                            $installmets_total += $value['InstallmentDetail']['amount'];
                        }

                        $sales_week = 0;
                        if(!empty($se['SalesEntry']['added_date'])) {
                            $date = new DateTime($se['SalesEntry']['added_date']);
                            $sales_week = $date->format('W');
                        }

                        $promo = 'Promo 1: '.$se['SalesEntry']['promo_1']."\n";
                        $promo .= 'Promo 2: '.$se['SalesEntry']['promo_2']."\n";
                        $promo .= 'Promo 3: '.$se['SalesEntry']['promo_3']."\n";
                        $promo .= 'Comments: '.$se['SalesEntry']['comments'];

                        $this->PhpExcel->addTableRow(array(
                            $se['SalesEntry']['client_no'],
                            $se['Customer']['name'],
                            $se['Customer']['dob'],
                            $se['Customer']['street_no'],
                            $se['Customer']['street_name'],
                            $se['Customer']['suburb'],
                            $se['Customer']['phone'],
                            $se['Customer']['mobile'],
                            $se['Customer']['city'],
                            $se['SalesEntry']['payment_start_date'],
                            $se['Product']['name'],
                            $se['Product']['color'],
                            $se['SalesEntry']['total_payment'],
                            $promo,
                            $sales_week,
                            $se['SalesEntry']['payment_frequency'],
                            $se['SalesEntry']['amount_per_payment'],
                            $se['SalesEntry']['mop'],
                            $se['SalesEntry']['initial_payment'],
                            $se['SalesEntry']['payment_detail'],
                            $se['User']['name'],
                            $se['TL']['name'],
                            count($installments),
                            $installmets_total,
                            $this->c_status[$se['SalesEntry']['commission_status']],
                            $this->d_status[$se['SalesEntry']['delivery_status']],
                            $se['SalesEntry']['product_delivery_date']
                        ));
                    }
                    $this->PhpExcel->getActiveSheet()->getStyle('N1:N'.$this->PhpExcel->getActiveSheet()->getHighestRow())->getAlignment()->setWrapText(true);
                }
            }

            // close table and output
            $this->PhpExcel->addTableFooter()->output('Payrun-'.$user['type'].'-'.date('d-m-Y H:i:s').'.xlsx');
            } else {
                $this->Session->setFlash('No '. strtoupper(str_replace('_', ' ', $user_type)) .' found.', 'admin_msg_bad');
            }
        }
    }

    function missing_payments() {
        $this->loadModel('InstallmentDetail');

        $this->Paginator->settings = array(
            'recursive'     => 0,
            'limit'         => 50,
            'conditions'    => array('InstallmentDetail.has_client' => 0),
            'order'         => array( 'InstallmentDetail.sales_code' => 'ASC')
        );

        $mps = $this->Paginator->paginate('InstallmentDetail'); 
        $this->set('mps', $mps);       
    }

    function mp_change_client() {
        $this->render = false;
        $this->layout = 'ajax';
        if($this->request->is('ajax')) {
            $key = $this->request->data('key');
            $client = trim($this->request->data('client'));
            $is_client = $this->SalesEntry->hasAny(array('SalesEntry.client_no' => $client));
            if($is_client) {
                $this->loadModel('InstallmentDetail');
                $this->InstallmentDetail->read(null, $key);
                $this->InstallmentDetail->set(array(
                    'sales_code' => $client,
                    'has_client' => 1
                ));
                $this->InstallmentDetail->save();
                $response = true;
            } else {
                $response = false;
            }
            echo $response;
        }
        exit;
    }
}