<?php

App::uses('AppController', 'Controller');
class GroupsController extends AppController {

    public $layout = 'admin_home';
    public $components = array('Auth', 'Acl');

    public function beforeFilter() {
        parent::beforeFilter();
        $this->Auth->allow('GroupStatus');
    }

    public function index() {
        $this->Group->recursive = 0;
        /*if($this->Session->read('userData.Group.role') == 'Admin'){
            $this->Session->setFlash('Access Granted !!', 'admin_msg_good');
            //return true;
        }
        else{
            $this->Session->setFlash('You Do not haing Permission to access this contents..', 'admin_msg_bad');
            $this->redirect(array('action'=>'dashboard','controller'=>'users'));
            return;
        }*/
        $this->set('groups', $this->Paginator->paginate());
    }

    public function view($id = null) {
        if (!$this->Group->exists($id)) {
            throw new NotFoundException(__('Invalid group'));
        }
        $options = array('conditions' => array('Group.' . $this->Group->primaryKey => $id));
        $this->set('group', $this->Group->find('first', $options));
    }

    public function add() {
        if ($this->request->is('post')) {
            $this->Group->create();
            if ($this->Group->save($this->request->data)) {
                $this->Session->setFlash('Group Created Sucessfully', 'admin_msg_good');
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash(__('The group could not be saved. Please, try again.', 'admin_msg_bad'));
            }
        }
    }

    public function edit($id = null) {
        
        $data = $this->Group->read(null, $id);
        
        if ($this->request->is(array('post', 'put'))) {
            if ($this->Group->save($this->request->data)) {
                $this->Session->setFlash('Group saved Sucessfully', 'admin_msg_good');
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash(__('The group could not be saved. Please, try again.','admin_msg_bad'));
            }
        } 
        
        if (!$this->request->data) {
            $this->data = $data;
        }
    }

    public function delete($id = null) {
        if (!empty($_POST)) {
            foreach ($_POST['delete_all'] as $key => $val) {
                $this->Group->delete($val);
            }
            $this->Session->setFlash('Group Deleted Sucessfully', 'admin_msg_good');
            return $this->redirect(array('action' => 'index'));
        }
    }

    public function GroupStatus() {
        $this->autoRender = FALSE;
        if($this->request->is('ajax')) {
            switch ($_GET['status']) {
                case 1:
                    $this->Group->updateAll(array('Group.status' => 0), array('Group.id' => $_GET['id']));
                    break;
                case 0:
                    $this->Group->updateAll(array('Group.status' => 1), array('Group.id' => $_GET['id']));
                    break;
            }
        }
    }

}
