<?php

App::uses('Component', 'Controller');
App::uses('Folder', 'Utility');
App::uses('File', 'Utility');

class ContractComponent extends Component {

  private $folder;

  private $types = [
    'contract' => PDF_PATH,
    'recordings' => VOICE_PATH,
  ];

  public function __construct(ComponentCollection $collection, $settings = array()) {
		parent::__construct($collection, $settings);

    $this->folder = new Folder(CONTRACT_PATH, true);

    $this->folder->create(PDF_PATH);
    $this->folder->create(VOICE_PATH);
  }

  public function file($name, $type = FALSE) {

    if(!empty($type)) {

      // checks proper field name is provided or not
      if(!array_key_exists($type, $this->types)) {
        return FALSE;
      } else {
        $name = $this->types[$type] . $name;
      }
    }

    return new File($name);
  }

  public function upload($file, $newName = null, $folder = null) {

    $response = array(
      'success' => FALSE,
      'message' => '',
    );
    
    if($file['error'] == 4) {

      // no file was selected for upload
      $response['message'] = 'No file is selected!';

    } elseif(Validation::extension($file['name'], ['pdf', 'mp3', 'm4a'])) {

      // process file upload
      $fileInfo = pathinfo($file['name']);
      
      $filename = $fileInfo['basename'];
      $ext = $fileInfo['extension'];
      $fileInfo['extension'] = strtolower($fileInfo['extension']);

      if(!empty($newName)) {

        $newExt = pathinfo($newName, PATHINFO_EXTENSION);

        $ext = (!empty($newExt) && (strcasecmp($ext, $newExt) == 0)) ? '' : '.' . $ext;

        $filename = $newName . $ext;
      }

      if(!empty($folder))
      {
        $fullPathFile = realpath($folder) . DS . $filename;
      }
      elseif($fileInfo['extension'] == 'pdf')
      {
        $fullPathFile = PDF_PATH . $filename;
      }
      elseif(in_array($fileInfo['extension'], ['mp3', 'm4a']))
      {
        $fullPathFile = VOICE_PATH . $filename;
      }

      if($this->file($fullPathFile)->exists()) {
        $response['message'] = $filename . ' file already exists!';

      } else {

        move_uploaded_file($file['tmp_name'], $fullPathFile);

        $response['success'] = TRUE;
        $response['message'] = $filename;
      }

    } else {
      
      // unacceptable file type
      $response['message'] = 'Invalid file type!';
    }

    return $response;
  }

  public function delete($type, $name) {

    $file = $this->file($name, $type);

    return $file->delete();
  }
}

