<?php

App::uses('AppController', 'Controller');

/**
 * Categories Controller
 *
 * @property Category $Category
 * @property PaginatorComponent $Paginator
 * @property SessionComponent $Session
 */
class CategoriesController extends AppController {

    /**
     * layout
     *
     * @var array
     */
    public $layout = 'admin_home';
    public $components = array('Acl');

    /**
     * index method
     *
     * @return void
     */
    public function beforeFilter() {
        parent::beforeFilter();
        $this->Auth->allow('categoryStatus');
    }


    public function index() {
        $this->Category->recursive = 0;
        $this->set('categories', $this->Paginator->paginate());
    }

    /**
     * view method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function view($id = null) {
        if (!$this->Category->exists($id)) {
            throw new NotFoundException(__('Invalid category'));
        }
        $options = array('conditions' => array('Category.' . $this->Category->primaryKey => $id));
        $this->set('category', $this->Category->find('first', $options));
    }

    /**
     * add method
     *
     * @return void
     */
    public function add() {
        if ($this->request->is('post')) {
            $this->Category->create();
            if ($this->Category->save($this->request->data)) {
                $this->Session->setFlash('Record Has been saved', 'admin_msg_good');
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash(__('The category could not be saved. Please, try again.'));
            }
        }
    }

    /**
     * edit method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
    public function edit($id = null) {
        
       $data = $this->Category->read(null, $id);
        
        if ($this->request->is(array('post', 'put'))) {
            if ($this->Category->save($this->request->data)) {
                $this->Session->setFlash('Group saved Sucessfully', 'admin_msg_good');
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Session->setFlash(__('The group could not be saved. Please, try again.','admin_msg_bad'));
            }
        } 
        
        if (!$this->request->data) {
            $this->data = $data;
        }
    }

    /**
     * delete method
     *
     * @throws NotFoundException
     * @param string $id
     * @return void
     */
      public function delete($id = null) {
        if (!empty($_POST)) {
            foreach ($_POST['delete_all'] as $key => $val) {
                $this->Category->delete($val);
            }
            $this->Session->setFlash('Group Deleted Sucessfully', 'admin_msg_good');
            return $this->redirect(array('action' => 'index'));
        }
    }
    

    public function categoryStatus() {
        $this->autoRender = FALSE;
        if ($this->RequestHandler->isAjax()) {
            switch ($_GET['status']) {
                case 1:
                    $this->Category->updateAll(array('Category.status' => 0), array('Category.id' => $_GET['id']));
                    break;
                case 0:
                    $this->Category->updateAll(array('Category.status' => 1), array('Category.id' => $_GET['id']));
                    break;
            }
        }
    }

}
