<?php
/**
 * Application level Controller
 *
 * This file is application-wide controller file. You can put all
 * application-wide controller-related methods here.
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Controller
 * @since         CakePHP(tm) v 0.2.9
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */

App::uses('Controller', 'Controller');

/**
 * Application Controller
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @package   app.Controller
 * @link    http://book.cakephp.org/2.0/en/controllers.html#the-app-controller
 */
class AppController extends Controller { 
    public $helpers = array('Form','Html');
    public $components = array(
      'Auth' => array(
          'authorize' => array(
                'Actions' => array('actionPath' => 'controllers')
            )
      ),
      'Acl','Session','RequestHandler','Paginator','Cookie');
   
    public function beforeFilter() {
        $this->Auth->loginAction = array('controller' => 'Users', 'action' => 'login');
        $this->Auth->loginRedirect = array('controller' => 'Users', 'action' => 'view');
        $this->Auth->logoutRedirect = array('controller' => 'Users', 'action' => 'login');
        $this->Auth->authorize = 'Controller';
        $this->checkLogin();
        $this->set('con', $this->params['controller']);
        $this->set('action', $this->params['action']);
    }

    public function isAuthorized($user = null) {

      $authFlag = false;
      if($user['Group']['role'] != 'Admin') {        

        $action = 'controllers';
        $action .= '/'.strtolower($this->name);
        $action .= '/'.$this->action;

        $db['aro'] = $this->Acl->Aro->node(array('User' => array('id' => $user['id']))); 
        $db['aco'] = $this->Acl->Aco->node($action);

        $db['con'] = ConnectionManager::getDataSource('default');
        $aa_node = $db['con']->fetchAll("SELECT *
        FROM `aros_acos` AS `AA`
        WHERE `AA`.`aro_id` = {$db['aro'][0]['Aro']['id']} AND `AA`.`aco_id` = {$db['aco'][0]['Aco']['id']}");

        $user_in_db = ($aa_node) ? true : false;     
        
        if($user_in_db && $authFlag == false && !empty($user)) {
            $authFlag = $this->Acl->check(array('User' => array('id' => $user['id'])), $action);
        }

        if(!$user_in_db && $authFlag == false && !empty($user)) {
            $authFlag = $this->Acl->check(array('Group' => array('id' => $user['group_id'])), $action);
        }

        if($authFlag == false && !empty($user)) {
            $this->redirect(array('controller' => 'useraccess', 'action' => 'no_access'));
        }
      } else {
        $authFlag = true;
      }

      return $authFlag;
    }

    protected function checkLogin() {
        if($this->Session->check('userData')) {
            $userData = $this->Session->read('userData');
            $this->set('user', $userData);
        } else {
            //$this->Session->setFlash('Please Login Using Username and Pasword', 'admin_msg_bad');
            
            if($this->params['controller'] == 'Users' && $this->params['action'] != 'login') {
              return $this->redirect(array('controller' => 'Users', 'action' => 'login'));              
            }
        }
    }

}
