<?php

App::uses('CakeEmail', 'Network/Email');
App::uses('CakeTime', 'Utility');

class AdminController extends AppController {

    public $components = array('Session', 'Cookie', 'RequestHandler');
    public $uses = array('Admin');
    public $helper = array('Form', 'Js');

    public function index() {
        $this->layout = 'admin_login';
        if (isset($_POST["btnSubmit"])) {
            $data = $this->Admin->find('first', array(
                'conditions' => array('user_name' => $_POST['txtName'], 'password' => md5($_POST['txtPassword']))
            ));

            if (isset($_POST['remember_me'])) {
                if ($_POST['remember_me'] == 'yes') {
                    setcookie("adminUsername", $_POST['txtName'], time() + 1000000);
                    setcookie("adminPassword", $_POST['txtPassword'], time() + 1000000);
                }
            } else {
                setcookie("adminUsername", $_POST['txtName'], time() - 1000000);
                setcookie("adminPassword", $_POST['txtPassword'], time() - 1000000);
            }

            if (!empty($data)) {
                $this->Session->write('adminLogged', $data);
                $this->Session->setFlash("Your Logged in SucessFully.", 'admin_msg_good');
                $this->redirect('/admin/dashbord');
            } else {
                $this->Session->setFlash("Please Enter Correct Username and Password", 'admin_msg_bad');
            }
        }
    }

    public function dashbord() {
        $this->layout = 'admin_home';
        $adminData = $this->Session->read('adminLogged');

        return $this->checkLogin();
    }

    /*public function generalSettings() {
        $this->layout = 'admin_home';

        if (empty($this->request->data)) {
            $this->data = $this->Option->read(null, 1);
        }

        if ($this->request->is("post") || $this->request->is("put")) {
            if (empty($this->request->data["Option"]["SITE_LOGO"]["name"])) {
                $this->request->data["Option"]["SITE_LOGO"]["name"] = $this->request->data["Option"]["CURRENT_SITE_LOGO"];
                $fileName = $this->request->data["Option"]["SITE_LOGO"]["name"];
            } else {
                $fileName = $this->request->data["Option"]["SITE_LOGO"]["name"];
            }

            $dirParh = WWW_ROOT . "img/admin/";
            unlink($dirParh . $this->request->data["Option"]["CURRENT_SITE_LOGO"]);
            move_uploaded_file($this->request->data["Option"]["SITE_LOGO"]["tmp_name"], $dirParh . $fileName);
            $this->request->data["Option"]["SITE_LOGO"] = $this->request->data["Option"]["SITE_LOGO"]["name"];


            $this->Option->id = 1;
            if ($this->Option->save($this->data)) {
                $this->redirect(array('action' => 'generalSettings'));
                return $this->Session->setFlash("Settings Saved Sucessfully.", 'admin_msg_good');
            } else {
                return $this->Session->setFlash("Settings Saved Failed", 'admin_msg_bad');
            }
        }

        return $this->checkLogin();
    }

    public function eanSettings() {
        $this->layout = 'admin_home';

        if (empty($this->request->data)) {
            $this->data = $this->Option->read(null, 1);
        }

        if ($this->request->is("put")) {
            $this->Option->id = 1;

            if ($this->Option->save($this->data)) {
                echo $this->Session->setFlash("Record Inserted Sucessfully", 'admin_msg_good');
                $this->redirect(array('action' => 'eanSettings'));
            } else {
                return $this->Session->setFlash("Record Inserted Failed", 'admin_msg_bad');
            }
        }
        return $this->checkLogin();
    }

    public function languageSetting() {
        $this->layout = 'admin_home';

        if (!empty($_POST)) {

            $this->Language->updateAll(array('Language.active' => 0));
            for ($i = 0; $i < count($_POST['ddl_All_Languages']); $i++) {

                if ($_POST['ddl_All_Languages'][$i] != '') {


                    $txtLangCode = $_POST['ddl_All_Languages'][$i];
                    $codes[] = $txtLangCode;
                    if ($this->Language->updateAll(array('Language.active' => 1), array('Language.code' => $txtLangCode))) {
                        $this->Session->setFlash('Saved Successfully!', 'admin_msg_good');
                    }
                }
            }


            if ($_POST['ddlLanguages'] != '') {
                $txtDefaultLang = $_POST['ddlLanguages'];

                if ($this->Language->updateAll(array('Language.default' => 1), array('Language.code' => $txtDefaultLang))) {

                    $this->Language->updateAll(array('Language.default' => 0), array('Language.code <>' => $txtDefaultLang));
                    $this->Session->setFlash('Saved Successfully!', 'admin_msg_good');
                }
            }
        }

        $activeLang = @$this->Language->find('all');

        $this->set('allLanguages', $activeLang);

        return $this->checkLogin();
    }

    public function currencySetting() {
        $this->layout = 'admin_home';

        if (@$this->request->is(post)) {

            $this->Currency->updateAll(array('Currency.active' => 0));
            foreach ($_POST["currencies"] as $arr) {
                for ($i = 0; $i < count($arr); $i++) {


                    if ($this->Currency->updateAll(array("active" => 1), array("code" => $arr))) {

                        $this->Session->setFlash('Saved Successfully!', 'admin_msg_good');
                    }
                }
            }

            if ($_POST["defaultCurrency"] != '') {
                if ($this->Currency->updateAll(array('Currency.default' => 1, 'Currency.max_nightly_rate' => 1), array('Currency.code' => $_POST["defaultCurrency"]))) {

                    $this->Currency->updateAll(array('Currency.default' => 0, 'Currency.max_nightly_rate' => 0), array('Currency.code <>' => $_POST["defaultCurrency"]));

                    $this->Session->setFlash('Saved Successfully!', 'admin_msg_good');
                }

                foreach ($_POST["currencies"] as $arr) {
                    for ($i = 0; $i < count($arr); $i++) {
                        $rate = $this->convertCurrency(1, $_POST["defaultCurrency"], $arr);
                        //echo $rate;exit;
                        $this->Currency->updateAll(array("max_nightly_rate" => $rate), array("code" => $arr));
                    }

                    $this->Currency->updateAll(array('Currency.default' => 1, 'Currency.max_nightly_rate' => 1), array('Currency.code' => $_POST["defaultCurrency"]));
                }
            }
        }

        $currency = @$this->Currency->find("all");

        $this->set("currency", $currency);

        return $this->checkLogin();
    }

    private function convertCurrency($amount, $from, $to) {
        $url = "https://www.google.com/finance/converter?a=$amount&from=$from&to=$to";
        $data = file_get_contents($url);
        preg_match("/<span class=bld>(.*)<\/span>/", $data, $converted);
        $converted = @preg_replace("/[^0-9.]/", "", $converted[1]);
        return round($converted, 3);
    }

    public function users() {
        $this->layout = 'admin_home';
        $users = $this->User->find("all");
        $this->set("users", $users);

        return $this->checkLogin();
    }

    public function userDetail($id = NULL) {
        $this->layout = 'admin_home';
        $data = $this->User->find("first", array(
            'conditions' => array('id' => $id)
        ));

        $this->set("user", $data);

        return $this->checkLogin();
    }

    public function editUser($id = Null) {
        $this->layout = 'admin_home';

        $data = $this->User->findById($id);

        if ($this->request->is(array('post', 'put'))) {
            $this->User->id = $id;
            if ($this->User->save($this->request->data)) {
                $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
                return $this->redirect(array('action' => 'users'));
            }
            $this->Session->setFlash('Unable to Update plz try again later', 'admin_msg_bad');
        }

        if (!$this->request->data) {
            $this->request->data = $data;
        }

        return $this->checkLogin();
    }

    public function deleteUsers() {
        $this->autoRender = FALSE;
        if (!empty($_POST)) {
            foreach ($_POST["delete_all"] as $key => $val) {
                $this->User->delete($val);
            }
            $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
            return $this->redirect(array('action' => 'users'));
        }
    }

    public function userStatus() {
        $this->autoRender = FALSE;
        switch ($this->params["named"]["status"]) {
            case 1:
                $this->User->updateAll(array("User.varification" => 0), array("User.id" => $this->params["named"]["id"]));
                $this->redirect(array("action" => "users"));
                break;
            case 0:
                $this->User->updateAll(array("User.varification" => 1), array("User.id" => $this->params["named"]["id"]));
                $this->redirect(array("action" => "users"));
                break;
        }
    }

    public function banners() {
        $this->layout = 'admin_home';

        $banners = $this->Banner->find("all");

        $this->set("banners", $banners);

        return $this->checkLogin();
    }

    public function addBanner() {
        $this->layout = 'admin_home';

        if ($this->request->is("post")) {
            $dir = WWW_ROOT . 'img/banner/';

            if (move_uploaded_file($this->request->data["Banner"]["image_name"]["tmp_name"], $dir . $this->request->data["Banner"]["image_name"]["name"])) {
                $this->request->data["Banner"]["image_name"] = $this->request->data["Banner"]["image_name"]["name"];
            }
            if ($this->Banner->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                return $this->redirect(array('action' => 'banners'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                return false;
            }
        }
        return $this->checkLogin();
    }

    public function editBanner($id = NULL) {
        $this->layout = "admin_home";

        $data = $this->Banner->read(null, $id);

        if ($this->request->is(array('post', 'put'))) {

            $dir = WWW_ROOT . 'img/banner/';
            if (!empty($this->request->data["Banner"]["image_name"]["name"])) {
                unlink($dir . $data["Banner"]["image_name"]);
                if (move_uploaded_file($this->request->data["Banner"]["image_name"]["tmp_name"], $dir . $this->request->data["Banner"]["image_name"]["name"])) {
                    $this->request->data["Banner"]["image_name"] = $this->request->data["Banner"]["image_name"]["name"];
                }
            } else {
                $this->request->data["Banner"]["image_name"] = $this->request->data["Banner"]["current_image_name"];
            }
            $this->Banner->id = $id;

            if ($this->request->data["Banner"]["type"] == "city") {
                $this->request->data["Banner"]["HotelName"] = NULL;
                $this->request->data["Banner"]["EANHotelID"] = NULL;
            }
            if ($this->Banner->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                return $this->redirect(array('action' => 'banners'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                return false;
            }
        }

        if (!$this->request->data) {
            $this->data = $data;
        }

        return $this->checkLogin();
    }

    public function bannerStatus() {
        $this->autoRender = FALSE;
        if ($this->RequestHandler->isAjax()) {
            switch ($_GET['status']) {
                case 1:
                    $this->Banner->updateAll(array("Banner.status" => 0), array("Banner.id" => $_GET["id"]));
                    break;
                case 0:
                    $this->Banner->updateAll(array("Banner.status" => 1), array("Banner.id" => $_GET["id"]));
                    break;
            }
        }
        return $this->checkLogin();
    }

    public function deleteBanners() {
        $this->autoRender = FALSE;

        if ($this->request->is("post")) {

            //echo '<pre>';
            //pr($this->request->data);exit;

            foreach ($_POST["delete_all"] as $key => $val) {
                $image_name = $this->Banner->find("first", array("conditions" => array("id" => $val)));
                $i = 0;
                foreach ($image_name as $value) {
                    unlink(WWW_ROOT . 'img/banner/' . $value["image_name"]);
                    $i++;
                }
                $this->Banner->delete($val);
            }
            $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
            return $this->redirect(array('action' => 'banners'));
        }

        return $this->checkLogin();
    }

    public function destinations() {
        $this->layout = 'admin_home';

        $continents = $this->Continent->find("all");

        $cities = $this->Destination->find("all");

        $this->set(array("continents" => $continents, "cities" => $cities));

        return $this->checkLogin();
    }

    public function addContinent() {
        $this->layout = 'admin_home';

        if ($this->request->is("post")) {
            $dir = WWW_ROOT . 'img/continent/';

            if (move_uploaded_file($this->request->data["Continent"]["image"]["tmp_name"], $dir . $this->request->data["Continent"]["image"]["name"])) {
                $this->request->data["Continent"]["image"] = $this->request->data["Continent"]["image"]["name"];
            }
            if ($this->Continent->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                return $this->redirect(array('action' => 'destinations'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                return false;
            }
        }

        return $this->checkLogin();
    }

    public function editContinent($id = NULL) {
        $this->layout = "admin_home";

        $data = $this->Continent->read(null, $id);

        if ($this->request->is(array('post', 'put'))) {

            $dir = WWW_ROOT . 'img/continent/';
            if (!empty($this->request->data["Continent"]["image"]["name"])) {
                unlink($dir . $data["Continent"]["image"]);
                if (move_uploaded_file($this->request->data["Continent"]["image"]["tmp_name"], $dir . $this->request->data["Continent"]["image"]["name"])) {
                    $this->request->data["Continent"]["image"] = $this->request->data["Continent"]["image"]["name"];
                }
            } else {
                $this->request->data["Continent"]["image"] = $this->request->data["Continent"]["current_image"];
            }
            $this->Continent->id = $id;


            if ($this->Continent->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                return $this->redirect(array('action' => 'destinations'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                return false;
            }
        }

        if (!$this->request->data) {
            $this->data = $data;
        }

        return $this->checkLogin();
    }

    public function deleteContinent() {
        $this->autoRender = FALSE;

        if ($this->request->is("post")) {

            foreach ($_POST["delete_all"] as $key => $val) {
                $image_name = @$this->Continent->find("first", array("conditions" => array("id" => $val)));
                $i = 0;
                foreach ($image_name as $value) {
                    @unlink(WWW_ROOT . 'img/continent/' . @$value["image"]);
                    $i++;
                }
                $this->Continent->delete($val);
            }
            $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
            return $this->redirect(array('action' => 'destinations'));
        }

        return $this->checkLogin();
    }

    public function continentStatus() {
        $this->autoRender = FALSE;
        if ($this->RequestHandler->isAjax()) {
            switch ($_GET['status']) {
                case 1:
                    $this->Continent->updateAll(array("Continent.status" => 0), array("Continent.id" => $_GET["id"]));
                    break;
                case 0:
                    $this->Continent->updateAll(array("Continent.status" => 1), array("Continent.id" => $_GET["id"]));
                    break;
            }
        }
        return $this->checkLogin();
    }

    public function addCity() {
        $this->layout = 'admin_home';

        $continents = $this->Continent->find("list", array(
            'conditions' => array('Continent.status' => 1)
        ));

        $this->set('continents', $continents);


        if ($this->request->is("post")) {

            if ($this->Destination->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                return $this->redirect(array('action' => 'destinations'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                return false;
            }
        }
        return $this->checkLogin();
    }

    public function editCity($id = NULL) {
        $this->layout = 'admin_home';

        $data = $this->Destination->read(NULL, $id);


        $continents = $this->Continent->find("list", array(
            'conditions' => array('Continent.status' => 1)
        ));

        $this->set("selectedContinent", $selected);
        $this->set('continents', $continents);



        if ($this->request->is(array('post', 'put'))) {
            $this->Destination->id = $id;
            if ($this->Destination->save($this->request->data)) {
                $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
                return $this->redirect(array('action' => 'destinations'));
            }
            $this->Session->setFlash('Unable to Update plz try again later', 'admin_msg_bad');
        }

        if (!$this->request->data) {
            $this->request->data = $data;
        }

        return $this->checkLogin();
    }

    public function deleteCity() {
        $this->autoRender = FALSE;

        if ($this->request->is("post")) {

            foreach ($_POST["delete_all"] as $key => $val) {

                $this->Destination->delete($val);
            }
            $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
            return $this->redirect(array('action' => 'destinations'));
        }

        return $this->checkLogin();
    }

    public function cityStatus() {
        $this->autoRender = FALSE;
        if ($this->RequestHandler->isAjax()) {
            switch ($_GET['status']) {
                case 1:
                    $this->Destination->updateAll(array("Destination.status" => 0), array("Destination.id" => $_GET["id"]));
                    break;
                case 0:
                    $this->Destination->updateAll(array("Destination.status" => 1), array("Destination.id" => $_GET["id"]));
                    break;
            }
        }
        return $this->checkLogin();
    }

    public function featureHotels() {
        $this->layout = 'admin_home';
        $this->set('hotels', $this->FeaturedHotel->find("all"));

        return $this->checkLogin();
    }

    public function addFeaturedHotel() {
        $this->layout = 'admin_home';

        $defaultCurrency = $this->Currency->find('first', array(
            'conditions' => array('Currency.default' => 1, 'Currency.active' => 1)
        ));

        $this->set('currency', $defaultCurrency);

        if ($this->request->is("post")) {

            $dir = WWW_ROOT . 'img/featuredHotel/';

            if (move_uploaded_file($this->request->data["FeaturedHotel"]["image"]["tmp_name"], $dir . $this->request->data["FeaturedHotel"]["image"]["name"])) {
                $this->request->data["FeaturedHotel"]["image"] = $this->request->data["FeaturedHotel"]["image"]["name"];
            }
            if ($this->FeaturedHotel->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_sucess_msg');
                return $this->redirect(array('action' => 'featureHotels'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_good');
                return false;
            }
        }
        return $this->checkLogin();
    }

    public function editFeaturedHotel($id = NULL) {
        $this->layout = "admin_home";

        $defaultCurrency = $this->Currency->find('first', array(
            'conditions' => array('Currency.default' => 1, 'Currency.active' => 1)
        ));

        $this->set('currency', $defaultCurrency);

        $data = $this->FeaturedHotel->read(null, $id);

        if ($this->request->is(array('post', 'put'))) {

            $dir = WWW_ROOT . 'img/featuredHotel/';
            if (!empty($this->request->data["FeaturedHotel"]["image"]["name"])) {
                unlink($dir . $data["FeaturedHotel"]["image"]);
                if (move_uploaded_file($this->request->data["FeaturedHotel"]["image"]["tmp_name"], $dir . $this->request->data["FeaturedHotel"]["image"]["name"])) {
                    $this->request->data["FeaturedHotel"]["image"] = $this->request->data["FeaturedHotel"]["image"]["name"];
                }
            } else {
                $this->request->data["FeaturedHotel"]["image"] = $this->request->data["FeaturedHotel"]["current_image_name"];
            }
            $this->FeaturedHotel->id = $id;


            if ($this->FeaturedHotel->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                return $this->redirect(array('action' => 'featureHotels'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                return false;
            }
        }

        if (!$this->request->data) {
            $this->data = $data;
        }

        return $this->checkLogin();
    }

    public function deleteFeaturedHotel() {
        $this->autoRender = FALSE;

        if ($this->request->is("post")) {

            foreach ($_POST["delete_all"] as $key => $val) {
                $image_name = $this->FeaturedHotel->find("first", array("conditions" => array("id" => $val)));
                $i = 0;
                foreach ($image_name as $value) {
                    unlink(WWW_ROOT . 'img/featuredHotel/' . $value["image"]);
                    $i++;
                }
                $this->FeaturedHotel->delete($val);
            }
            $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
            return $this->redirect(array('action' => 'featureHotels'));
        }

        return $this->checkLogin();
    }

    public function FeaturedHotelStatus() {
        $this->autoRender = FALSE;
        if ($this->RequestHandler->isAjax()) {
            switch ($_GET['status']) {
                case 1:
                    $this->FeaturedHotel->updateAll(array("FeaturedHotel.status" => 0), array("FeaturedHotel.id" => $_GET["id"]));
                    break;
                case 0:
                    $this->FeaturedHotel->updateAll(array("FeaturedHotel.status" => 1), array("FeaturedHotel.id" => $_GET["id"]));
                    break;
            }
        }
        return $this->checkLogin();
    }

    public function socials() {
        $this->layout = 'admin_home';
        $this->set('socials', $this->Social->find("all"));
        return $this->checkLogin();
    }

    public function addSocial() {
        $this->layout = 'admin_home';

        if ($this->request->is("post")) {
            $dir = WWW_ROOT . 'img/socials/';

            if (move_uploaded_file($this->request->data["Social"]["image"]["tmp_name"], $dir . $this->request->data["Social"]["image"]["name"])) {
                $this->request->data["Social"]["image"] = $this->request->data["Social"]["image"]["name"];
            }
            if ($this->Social->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                return $this->redirect(array('action' => 'socials'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                return false;
            }
        }
        return $this->checkLogin();
    }

    public function editSocial($id = NULL) {
        $this->layout = "admin_home";

        $data = $this->Social->read(null, $id);

        if ($this->request->is(array('post', 'put'))) {

            $dir = WWW_ROOT . 'img/socials/';
            if (!empty($this->request->data["Social"]["image"]["name"])) {
                unlink($dir . $data["Social"]["image"]);
                if (move_uploaded_file($this->request->data["Social"]["image"]["tmp_name"], $dir . $this->request->data["Social"]["image"]["name"])) {
                    $this->request->data["Social"]["image"] = $this->request->data["Social"]["image"]["name"];
                }
            } else {
                $this->request->data["Social"]["image"] = $this->request->data["Social"]["current_image_name"];
            }
            $this->Social->id = $id;

            if ($this->Social->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                return $this->redirect(array('action' => 'socials'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                return false;
            }
        }

        if (!$this->request->data) {
            $this->data = $data;
        }

        return $this->checkLogin();
    }

    public function socialStatus() {
        $this->autoRender = FALSE;
        if ($this->RequestHandler->isAjax()) {
            switch ($_GET['status']) {
                case 1:
                    $this->Social->updateAll(array("Social.status" => 0), array("Social.id" => $_GET["id"]));
                    break;
                case 0:
                    $this->Social->updateAll(array("Social.status" => 1), array("Social.id" => $_GET["id"]));
                    break;
            }
        }
        return $this->checkLogin();
    }

    public function deleteSocials() {
        $this->autoRender = FALSE;

        if ($this->request->is("post")) {
            foreach ($_POST["delete_all"] as $key => $val) {
                $image_name = $this->Social->find("first", array("conditions" => array("id" => $val)));
                $i = 0;
                foreach ($image_name as $value) {
                    unlink(WWW_ROOT . 'img/socials/' . $value["image"]);
                    $i++;
                }
                $this->Social->delete($val);
            }
            $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
            return $this->redirect(array('action' => 'socials'));
        }

        return $this->checkLogin();
    }

    public function cmsPages() {
        $this->layout = 'admin_home';

        $this->set('pages', $this->CmsPage->find("all"));

        return $this->checkLogin();
    }

    public function addCmsPage() {
        $this->layout = 'admin_home';

        if ($this->request->is("post")) {

            if ($this->CmsPage->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                return $this->redirect(array('action' => 'cmsPages'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                return false;
            }
        }
        return $this->checkLogin();
    }

    public function editCmsPage($id = NULL) {
        $this->layout = 'admin_home';

        $data = $this->CmsPage->read(NULL, $id);

        if ($this->request->is(array('post', 'put'))) {
            $this->CmsPage->id = $id;
            if ($this->CmsPage->save($this->request->data)) {
                $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
                return $this->redirect(array('action' => 'cmsPages'));
            }
            $this->Session->setFlash('Unable to Update plz try again later', 'admin_msg_bad');
        }

        if (!$this->request->data) {
            $this->request->data = $data;
        }

        return $this->checkLogin();
    }

    public function deleteCmsPages() {
        $this->autoRender = FALSE;

        if ($this->request->is("post")) {

            foreach ($_POST["delete_all"] as $key => $val) {

                $this->CmsPage->delete($val);
            }
            $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
            return $this->redirect(array('action' => 'cmsPages'));
        }

        return $this->checkLogin();
    }

    public function cmsStatus() {
        $this->autoRender = FALSE;
        if ($this->RequestHandler->isAjax()) {
            switch ($_GET['status']) {
                case 1:
                    $this->CmsPage->updateAll(array("CmsPage.status" => 0), array("CmsPage.id" => $_GET["id"]));
                    break;
                case 0:
                    $this->CmsPage->updateAll(array("CmsPage.status" => 1), array("CmsPage.id" => $_GET["id"]));
                    break;
            }
        }
        return $this->checkLogin();
    }

    public function bookings() {
        $this->layout = 'admin_home';

        $this->Booking->recursive = 1;

        $this->set('bookings', $this->Booking->find("all", array('order' => array('Booking.id DESC'))));

        return $this->checkLogin();
    }

    public function getData() {
        $this->autoRender = FALSE;
        $this->User->recursive = 1;
        echo '<pre>';
        pr($this->User->find("all"));
        exit;
    }

    public function profile($id = NULL) {

        $this->layout = 'admin_home';

        if ($this->request->is(array('post', 'put'))) {
            $this->Admin->id = $id;
            if ($this->Admin->save($this->data)) {
                $this->Session->setFlash('Your profile has been updated sucessfully', 'admin_msg_good');
                return $this->redirect(array("action" => "homepage"));
            } else {
                $this->Session->setFlash('Sorry! try again later', 'admin_msg_bad');
                return false;
            }
        }

        if (empty($this->data)) {
            $this->data = $this->Admin->read(NULL, $id);
        }

        return $this->checkLogin();
    }

    public function changePassword($id = NULL) {

        $this->layout = 'admin_home';

        if ($this->request->is(array('post', 'put'))) {
            $this->Admin->id = $id;
            $this->request->data["Admin"]["password"] = md5($this->request->data["Admin"]["newPassword"]);

            if ($this->Admin->save($this->request->data)) {
                $this->Session->setFlash('Your Password has been updated sucessfully', 'admin_msg_good');
                return $this->redirect(array("action" => "homepage"));
            } else {
                $this->Session->setFlash('Sorry! try again later', 'admin_msg_bad');
                return false;
            }
        }

        if (empty($this->data)) {
            $this->data = $this->Admin->read(NULL, $id);
        }

        return $this->checkLogin();
    }

    public function newslatterGroup() {

        $this->layout = 'admin_home';

        $this->set('groups', $this->NewsLatterGroup->find("all"));

        return $this->checkLogin();
    }

    public function addNewsLatterGroup() {
        $this->layout = 'admin_home';

        if ($this->request->is("post")) {

            if ($this->NewsLatterGroup->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                return $this->redirect(array('action' => 'newslatterGroup'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                return false;
            }
        }
        return $this->checkLogin();
    }

    public function editNewsLatterGroup($id = NULL) {
        $this->layout = 'admin_home';

        $data = $this->NewsLatterGroup->read(NULL, $id);

        if ($this->request->is(array('post', 'put'))) {
            $this->NewsLatterGroup->id = $id;
            if ($this->NewsLatterGroup->save($this->request->data)) {
                $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
                return $this->redirect(array('action' => 'newslatterGroup'));
            }
            $this->Session->setFlash('Unable to Update plz try again later', 'admin_msg_bad');
            return false;
        }

        if (!$this->request->data) {
            $this->request->data = $data;
        }

        return $this->checkLogin();
    }

    public function deletenewsLatterGroup() {
        $this->autoRender = FALSE;

        if ($this->request->is("post")) {

            foreach ($_POST["delete_all"] as $key => $val) {

                $this->NewsLatterGroup->delete($val);
            }
            $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
            return $this->redirect(array('action' => 'newslatterGroup'));
        }

        return $this->checkLogin();
    }

    public function newsLatterGroupStatus() {
        $this->autoRender = FALSE;
        if ($this->RequestHandler->isAjax()) {
            switch ($_GET['status']) {
                case 1:
                    $this->NewsLatterGroup->updateAll(array("NewsLatterGroup.status" => 0), array("NewsLatterGroup.id" => $_GET["id"]));
                    break;
                case 0:
                    $this->NewsLatterGroup->updateAll(array("NewsLatterGroup.status" => 1), array("NewsLatterGroup.id" => $_GET["id"]));
                    break;
            }
        }
        return $this->checkLogin();
    }

    public function subscribers() {
        $this->layout = 'admin_home';

        $this->Subscriber->recursive = 1;

        $this->set('subscribers', $this->Subscriber->find('all'));

        return $this->checkLogin();
    }

    public function addSubscribers() {
        $this->layout = 'admin_home';
        $data = $this->NewsLatterGroup->find('list', array(
            'fields' => array('NewsLatterGroup.groupName')
        ));

        $this->set('group', $data);

        /*
         * For Single Email Insert
         
        if (!empty($this->request->data['Subscriber']['email']) && empty($_FILES['csv']['name'])) {

            $count = $this->Subscriber->find('count', array(
                'conditions' => array('Subscriber.email' => $this->request->data['Subscriber']['email'])
            ));

            if ($count > 0) {
                $this->Session->setFlash('Email Already Exists', 'admin_msg_bad');
                return false;
            } else {

                if ($this->Subscriber->save($this->request->data)) {
                    $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                    return $this->redirect(array('action' => 'subscribers'));
                } else {
                    $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                    return false;
                }
            }
        }

        /*
         * For CSV Import
         
        if (empty($this->request->data['Subscriber']['email']) && !empty($_FILES['csv']['name'])) {
            if (isset($_FILES['csv']['size']) > 0 && $_FILES ['csv']['type'] == 'text/comma-separated-values') {
                if (move_uploaded_file($_FILES['csv']['tmp_name'], WWW_ROOT . 'files' . DS . $_FILES['csv'] ['name'])) {
                    try {
                        Configure::write('debug', 0);
                        $subscribers = array();
                        $row = 1;
                        if (($handle = fopen(WWW_ROOT . 'files' . DS . $_FILES['csv']['name'], "r")) !== FALSE) {
                            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                                $count = count($data);
                                for ($i = 0; $i < $count; $i++) {

                                    $count = $this->Subscriber->find('count', array(
                                        'conditions' => array('Subscriber.email' => $data[$i])
                                    ));

                                    if ($count == 0) {

                                        $subscribers["Subscriber"]["email"] = $data[$i];
                                        $subscribers["Subscriber"]["group_id"] = $this->request->data['Subscriber']['group_id'];
                                        $subscribers["Subscriber"]["status"] = 1;
                                        $this->Subscriber->create();
                                        if ($this->Subscriber->save($subscribers)) {
                                            $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                                            return $this->redirect(array('action' => 'subscribers'));
                                        } else {
                                            $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                                            return false;
                                        }
                                    }
                                }
                            }
                            fclose($handle);
                        }
                    } catch (Exception $ex) {
                        throw new InternalErrorException();
                    }
                }
            } else {
                $this->Session->setFlash('Please Select CSV File', 'admin_msg_bad');
                return false;
            }
        }

        if (!empty($this->request->data['Subscriber']['email']) && !empty($_FILES['csv']['name'])) {
            $this->Session->setFlash('Please Select Either Email or CSV File', 'admin_msg_bad');
            return false;
        }


        return $this->checkLogin();
    }

    public function editSubscribers($id = NULL) {
        $this->layout = 'admin_home';

        $data = $this->Subscriber->read(NULL, $id);

        $group = $this->NewsLatterGroup->find('list', array(
            'fields' => array('NewsLatterGroup.groupName')
        ));

        $this->set('group', $group);


        if ($this->request->is(array('post', 'put'))) {
            $this->subscribers()->id = $id;
            if ($this->Subscriber->save($this->request->data)) {
                $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
                return $this->redirect(array('action' => 'subscribers'));
            }
            $this->Session->setFlash('Unable to Update plz try again later', 'admin_msg_bad');
        }

        if (!$this->request->data) {
            $this->request->data = $data;
        }

        return $this->checkLogin();
    }

    public function deleteSubscribers() {
        $this->autoRender = FALSE;

        if ($this->request->is("post")) {

            foreach ($_POST["delete_all"] as $key => $val) {

                $this->Subscriber->delete($val);
            }
            $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
            return $this->redirect(array('action' => 'subscribers'));
        }

        return $this->checkLogin();
    }

    public function subscriberStatus() {
        $this->autoRender = FALSE;
        if ($this->RequestHandler->isAjax()) {
            switch ($_GET['status']) {
                case 1:
                    $this->Subscriber->updateAll(array("Subscriber.status" => 0), array("Subscriber.id" => $_GET["id"]));
                    break;
                case 0:
                    $this->Subscriber->updateAll(array("Subscriber.status" => 1), array("Subscriber.id" => $_GET["id"]));
                    break;
            }
        }
        return $this->checkLogin();
    }

    public function importSubscribers() {
        $this->layout = 'admin_home';

        if ($this->request->is('post') || $this->request->is('put')) {
            if (isset($_FILES['csv']['size']) > 0 && $_FILES ['csv']['type'] == 'text/comma-separated-values') {
                if (move_uploaded_file($_FILES['csv']['tmp_name'], WWW_ROOT . 'files' . DS . $_FILES['csv'] ['name'])) {
                    try {
                        Configure::write('debug', 0);
                        $subscribers = array();
                        $row = 1;
                        if (($handle = fopen(WWW_ROOT . 'files' . DS . $_FILES['csv']['name'], "r")) !== FALSE) {
                            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                                $count = count($data);
                                for ($i = 0; $i < $count; $i++) {
                                    $subscribers["Subscriber"]["email"] = $data[$i];
                                    $this->Subscriber->create();
                                    $this->Subscriber->save($subscribers);
                                }
                            }
                            fclose($handle);
                        }exit;
                    } catch (Exception $ex) {
                        throw new InternalErrorException();
                    }
                }
            }
        }

        return $this->checkLogin();
    }

    public function mailTemplates() {
        $this->layout = 'admin_home';

        $this->set("templates", $this->MailTemplate->find("all"));

        return $this->checkLogin();
    }

    public function addTemplate() {
        $this->layout = 'admin_home';

        if ($this->request->is("post")) {

            if ($this->MailTemplate->save($this->request->data)) {
                $this->Session->setFlash('Your record has been added sucessfully.', 'admin_msg_good');
                return $this->redirect(array('action' => 'mailTemplates'));
            } else {
                $this->Session->setFlash('there is a problem .', 'admin_msg_bad');
                return false;
            }
        }
        return $this->checkLogin();
    }

    public function editTemplate($id = NULL) {
        $this->layout = 'admin_home';

        $data = $this->MailTemplate->read(NULL, $id);

        if ($this->request->is(array('post', 'put'))) {
            $this->MailTemplate->id = $id;
            if ($this->MailTemplate->save($this->request->data)) {
                $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
                return $this->redirect(array('action' => 'mailTemplates'));
            }
            $this->Session->setFlash('Unable to Update plz try again later', 'admin_msg_bad');
        }

        if (!$this->request->data) {
            $this->request->data = $data;
        }

        return $this->checkLogin();
    }

    public function deleteTemplates() {
        $this->autoRender = FALSE;

        if ($this->request->is("post")) {

            foreach ($_POST["delete_all"] as $key => $val) {

                $this->MailTemplate->delete($val);
            }
            $this->Session->setFlash('Your record has been updated.', 'admin_msg_good');
            return $this->redirect(array('action' => 'mailTemplates'));
        }

        return $this->checkLogin();
    }

    public function templateStatus() {
        $this->autoRender = FALSE;
        if ($this->RequestHandler->isAjax()) {
            switch ($_GET['status']) {
                case 1:
                    $this->MailTemplate->updateAll(array("MailTemplate.status" => 0), array("MailTemplate.id" => $_GET["id"]));
                    break;
                case 0:
                    $this->MailTemplate->updateAll(array("MailTemplate.status" => 1), array("MailTemplate.id" => $_GET["id"]));
                    break;
            }
        }
        return $this->checkLogin();
    }

    public function sendMassmail() {
        $this->layout = 'admin_home';



        $group = $this->NewsLatterGroup->find('list', array(
            'conditions' => array('NewsLatterGroup.status' => 1),
            'fields' => array('NewsLatterGroup.groupName')
        ));


        $subject = $this->MailTemplate->find('list', array(
            'fields' => array('MailTemplate.subject'),
            'conditions' => array('MailTemplate.status' => 1)
        ));

        $this->set("subject", $subject);

        $this->set('group', $group);


        if (!empty($this->request->data)) {



            $to = $this->request->data["to"];
            $from = $this->request->data["From"];
            $fromEmail = $this->request->data["fromEmail"];


            foreach ($to as $val) {
                $Email = new CakeEmail();
                $Email->from(array($fromEmail => $from));
                $Email->to(array($val));
                $Email->emailFormat('html');
                $Email->subject($this->request->data["SentMail"]["template"]);
                if ($Email->send($this->request->data["content"])) {
                    $data = array(
                        'template' => $this->request->data['SentMail']['template'],
                        'groupName' => $this->request->data['SentMail']['groupName']
                    );
                    if ($this->SentMail->save($data)) {
                        $this->Session->setFlash('Mail Send Sucessfully', 'admin_msg_good');
                    }
                } else {
                    $this->Session->setFlash('There is a problem', 'admin_msg_bad');
                    return false;
                }
            }
            return $this->redirect(array('action' => 'mailRecords'));
        }
        return $this->checkLogin();
    }

    public function getTemplate() {
        $this->layout = 'ajax';
        if ($this->RequestHandler->isAjax()) {
            if (!empty($this->data["ddlTemplate"]) && !empty($this->data["ddlGroup"])) {
                $template = $this->MailTemplate->find("first", array(
                    'conditions' => array("MailTemplate.id" => $this->data["ddlTemplate"])
                ));


                $subscriber = $this->NewsLatterGroup->Subscriber->find("all", array(
                    'conditions' => array("NewsLatterGroup.id" => $this->data["ddlGroup"], 'NewsLatterGroup.status' => 1, 'Subscriber.status' => 1),
                ));

                if (!empty($subscriber)) {

                    $this->set("subscribers", $subscriber);
                    $this->set("template", $template);
                } else {
                    echo 'There is no subscriber in this group';
                    exit;
                }
            } else {
                echo 'Please Select Template and Group !';
                exit;
            }
        }
    }

    public function mailRecords() {
        $this->layout = 'admin_home';
        $this->set('records', $this->SentMail->find('all', array('order' => array('SentMail.time DESC'))));
        return $this->checkLogin();
    }

    public function deletMailRecords() {
        $this->autoRender = FALSE;

        if ($this->request->is("post")) {

            foreach ($_POST["delete_all"] as $key => $val) {

                $this->SentMail->delete($val);
            }
            $this->Session->setFlash('Your record has been deleted sucessfully.', 'admin_msg_good');
            return $this->redirect(array('action' => 'mailRecords'));
        }

        return $this->checkLogin();
    }

    public function logout() {

        $this->autoRender = false;

        if ($this->Session->check('adminLogged') == true) {

            $this->set('title_for_layout', 'Logout : ' . SITE_TITLE);
            $this->Session->delete('adminLogged');
            $this->Session->destroy();
        }

        $this->Session->setFlash('You are successfully logged out.', 'admin_msg_good');
        $this->redirect('/admins/index');
    }

    public function forgetPassword() {
        $this->layout = 'admin_login';
        $this->autoRender = true;
        if ($this->request->is("post")) {
            $data = $this->Admin->find("first", array(
                "conditions" => array("Admin.email" => $_POST["txtemail"])
            ));

            if (!empty($data)) {

                $timestamp = strtotime(date('d-m-Y', time()));
                $uniqueValue = $timestamp . rand(1, 15);
                $activation_key = md5($uniqueValue);

                $this->Admin->id = $data['Admin']['user_id'];

                $result = $this->Admin->save(array('user_activation_key' => $activation_key));

                if ($result == true) {
                    $url = 'http://' . $_SERVER["SERVER_NAME"] . DS . 'demo' . DS . 'fionaAdvert' . DS . 'admins' . DS . 'resetPassword?key=' . $activation_key;

                    $msg = 'hii,' . $data["Admin"]["first_name"] . '&nbsp;' . $data["Admin"]["last_name"] . '<br>';
                    $msg.="<a href=" . $url . ">Click Here</a><br>";
                    $msg.="or Copy Following link in ypur browser : " . $url;


                    $email = new CakeEmail();
                    $email->to($this->request->data["txtemail"]);
                    $email->from(array("admin@email.com" => 'Administrator'));
                    $email->subject("Password Reset");
                    $email->emailFormat("both");

                    if ($email->send($msg)) {
                        $this->Session->setFlash('Please Check Your Email, Password reset Instruction has been sent to your email.', 'admin_msg_good');
                        $this->redirect('/admins');
                    } else {
                        $this->Session->setFlash('There is a problem with your email, please try later', 'admin_msg_bad');
                        return false;
                    }
                } else {

                }
            } else {
                $this->Session->setFlash('Email not exists', 'admin_msg_bad');
            }
        }
    }

    public function resetPassword() {
        $this->layout = 'admin_login';


        if (isset($_GET['key'])) {

            $key = trim($_GET['key']);
            if ($key != '')
                $data = $this->Admin->find('first', array('conditions' => array('user_activation_key' => $key)));
            $this->set('data', $data);
            $this->Cookie->write('data', $data);
        }

        $data = $this->Cookie->read('data');

        if (empty($data)) {

            $this->Session->setFlash('Please enter your Registered Email address !!!', 'admin_msg_bad');
            $this->redirect('/admins/forgetPassword');
        } else {
            if (!empty($_POST)) {

                if ($_POST['txtPass'] != '') {
                    $pass = @trim($_POST['txtPass']);
                } else {
                    $error = true;
                    $this->Session->setFlash('Please Enter your New Password !!!', 'admin_msg_bad');
                }

                if ($_POST['txtcpass'] != '') {
                    $pass1 = @trim($_POST['txtcpass']);
                } else {
                    $error = true;
                    $this->Session->setFlash('Password Field is blank !!!', 'admin_msg_bad');
                }

                if ($pass != $pass1) {
                    $error = true;
                    $this->Session->setFlash('Password Not Match !!!', 'admin_msg_bad');
                }

                if ($error != true) {
                    $this->Admin->id = $data['Admin']['user_id'];

                    if ($this->Admin->save(array('password' => md5($pass1)))) {
                        $this->Cookie->write('data', '');
                        $this->Session->setFlash('Password Reset Successfully!!!', 'admin_msg_good');
                        $this->redirect('/admins/index');
                    }
                }
            }
        }
    }

    protected function checkLogin() {
        $adminData = $this->Session->read('adminLogged');

        if (!$this->Session->check("adminLogged")) {
            $this->Session->setFlash('Please login to continue', 'admin_msg_bad');
            $this->redirect(array('action' => 'index'));
        }

        if (!empty($adminData)) {
            $this->set('username', $adminData['Admin']['user_name']);
            $this->set('userId', $adminData['Admin']['user_id']);
        }
    }

    public function ajaxAutoSuggestHotel() {
        $this->autoRender = false;
        if ($this->RequestHandler->isAjax()) {

            Configure::write('debug', 0);
            $this->autoRender = false;


            $ActivePropertyLists = $this->ActivePropertyList->find('all', array('conditions' => array('OR' => array('ActivePropertyList.City LIKE' => $_GET['term'] . '%', 'ActivePropertyList.Name LIKE' => $_GET['term'] . '%')), 'limit' => 5));

            $i = 0;
            foreach ($ActivePropertyLists as $row1) {
                $response[$i]['name'] = $row1['ActivePropertyList']['Name'];
                $name_0 = $row1['ActivePropertyList']['Name'];
                $response[$i]['address'] = $row1['ActivePropertyList']['Address1'];
                $response[$i]['city'] = $row1['ActivePropertyList']['City'];
                $response[$i]['state'] = $row1['ActivePropertyList']['StateProvince'];
                $response[$i]['country'] = $row1['ActivePropertyList']['Country'];

                $response[$i]['latitude'] = $row1['ActivePropertyList']['Latitude'];
                $response[$i]['longitude'] = $row1['ActivePropertyList']['Longitude'];
                $response[$i]['HotelID'] = $row1['ActivePropertyList']['EANHotelID'];
                $response[$i]['type'] = 'htls__';

                $response[$i]['label'] = $row1['ActivePropertyList']['Name'] . ',' . $row1['ActivePropertyList']['City'];
                $response[$i]['value'] = $row1['ActivePropertyList']['Name'] . ',' . $row1['ActivePropertyList']['City'];
                $response[$i]['category'] = 'Hotel';
                $i++;
            }

            if (empty($ActivePropertyLists)) {
                $response[0]['label'] = 'No destination found';
                $response[0]['value'] = null;
                $response[0]['category'] = '404 ! Not Found.';
            }

            echo json_encode($response);
            exit;
        }
        return $this->checkLogin();
    }

    public function ajaxAutoSuggestCity() {
        $this->autoRender = FALSE;

        if ($this->RequestHandler->isAjax()) {

            Configure::write('debug', 0);

            $CityCoordinatesLists = $this->CityList->find('all', array('conditions' => array('CityList.RegionName LIKE' => $_GET['term'] . '%'), 'order' => array('RegionID'), 'limit' => 5));
            $i = 0;

            foreach ($CityCoordinatesLists as $row3) {
                if (LANGUAGE_CODE == 'ar_SA') {
                    $response[$i]['label'] = $row3['CityList']['RegionName_ar'];
                } else {
                    $response[$i]['label'] = $row3['CityList']['RegionName'];
                }
                $response[$i]['Cordinates'] = $row3['CityList']['Coordinates'];

                $arr = explode(":", $response[$i]['Cordinates']);
                $newVal = explode(";", $arr[0]);
                $response[$i]['latitude'] = $newVal[0];
                $response[$i]['longitude'] = $newVal[1];

                $response[$i]['value'] = $row3['CityList']['RegionName'];
                $response[$i]['category'] = 'City';
                $i++;
            }


            if (empty($CityCoordinatesLists)) {
                $response[0]['label'] = 'No destination found';
                $response[0]['value'] = null;
                $response[0]['category'] = '404 ! Not Found.';
            }

            echo json_encode($response);
            exit;
        }
    }*/

}
